/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryCache;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellProgram;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.world.WorldChunkTracker;

public class SpellFactory {
    private final SpellRegistry spellRegistry;
    private final WolDirectories directories;
    private final WolModule wolModule;
    private final WorldChunkTracker worldChunkTracker;
    private final LuaFunctionBinaryCache luaFunctionCache = new LuaFunctionBinaryCache();
    private final ChunkForceManager chunkForceManager = new ChunkForceManager();
    private long nextSid = 1L;

    public SpellFactory(SpellRegistry spellRegistry, WolDirectories directories, WolModule wolModule, WorldChunkTracker worldChunkTracker) {
        this.spellRegistry = Objects.requireNonNull(spellRegistry, "spellRegistry");
        this.directories = Objects.requireNonNull(directories, "directories");
        this.wolModule = Objects.requireNonNull(wolModule, "wolModule");
        this.worldChunkTracker = Objects.requireNonNull(worldChunkTracker, "worldChunkTracker");
    }

    public Spell createSpell(class_2168 commandSource, String code, LinkedHashMap<Object, Object> argsMap) {
        SpellScope spellScope = new SpellScope(this.spellRegistry, this.chunkForceManager, this.directories, this.wolModule, this.worldChunkTracker, commandSource);
        SpellProgram program = new SpellProgram(this.luaFunctionCache, spellScope, code, argsMap);
        ++this.nextSid;
        class_243 pos = commandSource.method_9222();
        Spell spell = new Spell(this.nextSid, spellScope, pos, program);
        this.spellRegistry.add(spell);
        spell.tick();
        return spell;
    }
}

