/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.chunk.ChunkUtil;
import net.wizardsoflua.chunk.Ticket;
import net.wizardsoflua.spell.VirtualEntity;

public class VirtualEntityChunkForceSupport {
    private final ChunkForceManager support;
    private final VirtualEntity entity;
    private Ticket chunkLoaderTicket;
    private class_1923 chunkPos;

    public VirtualEntityChunkForceSupport(ChunkForceManager support, VirtualEntity entity) {
        this.support = support;
        this.entity = entity;
        this.chunkPos = new class_1923(entity.getBlockPos());
        this.loadChunk(this.chunkPos);
        this.loadChunkProximity(this.chunkPos);
    }

    public void requestNewTicket() {
        if (this.hasTicket()) {
            this.releaseTicket();
        }
        this.chunkPos = new class_1923(this.entity.getBlockPos());
        this.chunkLoaderTicket = new Ticket(this.entity.getWorld());
        if (this.chunkLoaderTicket == null) {
            throw new IllegalStateException("Could not get a ChunkLoading ticket for Wizards of Lua!");
        }
        this.loadChunkProximity(this.chunkPos);
        this.support.forceChunk(this.chunkLoaderTicket, this.chunkPos);
    }

    public boolean hasTicket() {
        return this.chunkLoaderTicket != null;
    }

    public void releaseTicket() {
        if (this.hasTicket()) {
            this.chunkLoaderTicket.release();
            this.chunkLoaderTicket = null;
        }
    }

    public void updatePosition() {
        class_2338 pos = this.entity.getBlockPos();
        if (!ChunkUtil.contains(this.chunkPos, pos)) {
            if (this.chunkLoaderTicket != null) {
                this.support.unforceChunk(this.chunkLoaderTicket, this.chunkPos);
                this.chunkPos = new class_1923(pos);
                this.loadChunkProximity(this.chunkPos);
                this.support.forceChunk(this.chunkLoaderTicket, this.chunkPos);
            } else {
                this.chunkPos = new class_1923(pos);
                this.loadChunk(this.chunkPos);
                this.loadChunkProximity(this.chunkPos);
            }
        }
    }

    private void loadChunk(class_1923 chunkPos) {
        this.entity.getWorld().method_8497(chunkPos.field_9181, chunkPos.field_9180);
    }

    private void loadChunkProximity(class_1923 center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.entity.getWorld().method_8497(center.field_9181 + x, center.field_9180 + z);
            }
        }
    }
}

