package net.wizardsoflua;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.wizardsoflua.command.LuaCommand;
import net.wizardsoflua.command.WolExtractApiCommand;
import net.wizardsoflua.command.WolExtractExamplesCommand;
import net.wizardsoflua.command.WolSpellBreakCommand;
import net.wizardsoflua.command.WolSpellListCommand;
import net.wizardsoflua.command.WolStartupCommand;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;
import net.wizardsoflua.event.SpellTerminatedCallback;
import net.wizardsoflua.event.WolEventHandler;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.spell.SpellCaster;
import net.wizardsoflua.spell.SpellFactory;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.startup.Startup;
import net.wizardsoflua.world.WorldChunkTracker;

public class WizardsOfLuaMod implements ModInitializer {
  public static final String MOD_ID = "wizardsoflua";
  public static final int WOL_PERMISSION_LEVEL = 2;

  public static Logger LOGGER;
  private WolDirectories directories;
  private WolModule wolModule;
  private SpellRegistry spellRegistry;
  private WorldChunkTracker worldChunkTracker;
  private SpellFactory spellFactory;
  private SpellCaster spellCaster;
  private WolEventHandler eventHandler;
  private DynamicCommandManager dynamicCommandManager;
  private Startup startup;

  @Override
  public void onInitialize() {
    LOGGER = LoggerFactory.getLogger(MOD_ID);
    directories = new WolDirectories();
    wolModule = new WolModule(this::getVersion, this::getDynamicCommandManager);
    spellRegistry = new SpellRegistry();
    worldChunkTracker = new WorldChunkTracker();
    spellFactory = new SpellFactory(spellRegistry, directories, wolModule, worldChunkTracker);
    spellCaster = new SpellCaster(spellFactory);
    eventHandler = new WolEventHandler(spellRegistry, worldChunkTracker);
    try {
      dynamicCommandManager = new DynamicCommandManager(spellCaster);
    } catch (ReflectiveOperationException e) {
      throw new RuntimeException(e);
    }
    startup = new Startup(directories, spellRegistry, spellCaster, wolModule);
    CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
      new LuaCommand(spellCaster).register(dispatcher, registryAccess, environment);
      new WolSpellListCommand(spellRegistry).register(dispatcher, registryAccess, environment);
      new WolSpellBreakCommand(spellRegistry).register(dispatcher, registryAccess, environment);
      new WolStartupCommand(startup).register(dispatcher, registryAccess, environment);
      new WolExtractApiCommand(directories).register(dispatcher, registryAccess, environment);
      new WolExtractExamplesCommand(directories).register(dispatcher, registryAccess, environment);
      dynamicCommandManager.reload(dispatcher, registryAccess);
    });

    ServerLifecycleEvents.SERVER_STARTED.register(server -> startup.run(server.method_3739()));
    ServerLifecycleEvents.SERVER_STOPPING
        .register(server -> spellRegistry.breakSpells(spellRegistry.getAll()));
    ServerTickEvents.START_SERVER_TICK.register(server -> spellRegistry.tick());
    ServerTickEvents.START_SERVER_TICK.register(server -> dynamicCommandManager.tick(server));
    SpellTerminatedCallback.EVENT.register(spellRegistry::onSpellTermiated);
    eventHandler.register();
  }

  public @Nullable String getVersion() {
    return FabricLoader.getInstance().getModContainer(MOD_ID).map(it -> {
      Version version = it.getMetadata().getVersion();
      return version.getFriendlyString();
    }).orElse("");
  }

  private DynamicCommandManager getDynamicCommandManager() {
    return dynamicCommandManager;
  }
}
