package net.wizardsoflua;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class WolDirectories {
  private final Path fabricConfigDir = FabricLoader.getInstance().getConfigDir();
  private final Path wolConfigDir = createDirectory(fabricConfigDir, "wizards-of-lua");
  private final Path luaSrcDir = wolConfigDir;
  private Path luaApiDir;
  private Path examplesDir;

  public Path getFabricConfigDir() {
    return fabricConfigDir;
  }

  public Path getWolConfigDir() {
    return wolConfigDir;
  }

  public Path getLuaSrcDir() {
    return luaSrcDir;
  }

  public Path getLuaApiDir() {
    if (luaApiDir == null) {
      luaApiDir = createDirectory(wolConfigDir, "api");
    }
    return luaApiDir;
  }

  public Path getExamplesDir() {
    if (examplesDir == null) {
      examplesDir = createDirectory(wolConfigDir, "examples");
    }
    return examplesDir;
  }

  public String getLuaSearchPath(FileSystem fileSystem) {
    return luaSrcDir.toString() + fileSystem.getSeparator() + "?.lua;";
  }

  private Path createDirectory(Path parent, String dir) {
    Path result = parent.resolve(dir).toAbsolutePath().normalize();
    createDirectory(result);
    return result;
  }

  private void createDirectory(Path path) {
    WizardsOfLuaMod.LOGGER.info("Creating " + path.toString());
    try {
      Files.createDirectories(path);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
}
