package net.wizardsoflua.command;

import static java.util.Objects.requireNonNull;
import static net.minecraft.class_2170.method_9247;
import static net.wizardsoflua.WizardsOfLuaMod.WOL_PERMISSION_LEVEL;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_7157;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.extract.LuaExamplesExtractor;

public class WolExtractExamplesCommand implements CommandRegisterer, Command<class_2168> {
  private static final String WOL_PERMISSION = WizardsOfLuaMod.MOD_ID + ".wol";
  private static final String WOL_EXTRACT_EXAMPLES_PERMISSION =
      WOL_PERMISSION + ".extract.examples";

  private final WolDirectories directories;
  private final LuaExamplesExtractor extractor = new LuaExamplesExtractor();

  public WolExtractExamplesCommand(WolDirectories directories) {
    this.directories = requireNonNull(directories, "directories");
  }

  @Override
  public void register(CommandDispatcher<class_2168> dispatcher,
      class_7157 registryAccess, class_5364 environment) {
    dispatcher.register(//
        method_9247("wol")//
            .requires(source -> source.method_9228() == null
                || Permissions.check(source, WOL_PERMISSION, WOL_PERMISSION_LEVEL)) //
            .then(method_9247("extract")//
                .then(method_9247("examples")//
                    .requires(source -> source.method_9228() == null || Permissions.check(source,
                        WOL_EXTRACT_EXAMPLES_PERMISSION, WOL_PERMISSION_LEVEL)) //
                    .executes(this))));
  }

  @Override
  public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
    return extractor.run(context.getSource(), directories.getExamplesDir());
  }
}
