package net.wizardsoflua.command.dynamic;

import java.lang.reflect.Field;
import com.mojang.brigadier.tree.CommandNode;
import net.wizardsoflua.WizardsOfLuaMod;

public class CommandNodeRemover {
  private final Field childrenField;
  private final Field literalsField;
  private final Field argumentsField;

  public CommandNodeRemover() throws ReflectiveOperationException {
    Class<?> cmdNodeClass = com.mojang.brigadier.tree.CommandNode.class;
    childrenField = cmdNodeClass.getDeclaredField("children");
    literalsField = cmdNodeClass.getDeclaredField("literals");
    argumentsField = cmdNodeClass.getDeclaredField("arguments");
    childrenField.setAccessible(true);
    literalsField.setAccessible(true);
    argumentsField.setAccessible(true);
  }

  public void removeChildFrom(CommandNode<?> parent, CommandNode<?> child) {
    String key = child.getName();
    try {
      Object childrenObj = childrenField.get(parent);
      Object literalsObj = literalsField.get(parent);
      Object argumentsObj = argumentsField.get(parent);
      if (childrenObj instanceof java.util.Map)
        ((java.util.Map<?, ?>) childrenObj).remove(key);
      if (literalsObj instanceof java.util.Map)
        ((java.util.Map<?, ?>) literalsObj).remove(key);
      if (argumentsObj instanceof java.util.Map)
        ((java.util.Map<?, ?>) argumentsObj).remove(key);
    } catch (ReflectiveOperationException e) {
      WizardsOfLuaMod.LOGGER.warn(
          "DynamicCommandManager: could not fully remove internals for '{}': {}", key,
          e.toString());
    }
  }
}
