package net.wizardsoflua.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.wizardsoflua.spell.Spell;

public interface SpellTerminatedCallback {

  Event<SpellTerminatedCallback> EVENT =
      EventFactory.createArrayBacked(SpellTerminatedCallback.class, (listeners) -> spell -> {
        for (SpellTerminatedCallback listener : listeners) {
          listener.onSpellTerminated(spell);
        }
      });

  void onSpellTerminated(Spell spell);
}
