package net.wizardsoflua.event;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3966;
import net.minecraft.server.MinecraftServer;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.spell.SpellServerCommandSource;
import net.wizardsoflua.world.WorldChunkTracker;

public class WolEventHandler {
  private final SpellRegistry spellRegistry;
  private final WorldChunkTracker worldChunkTracker;

  public WolEventHandler(SpellRegistry spellRegistry, WorldChunkTracker worldChunkTracker) {
    this.spellRegistry = spellRegistry;
    this.worldChunkTracker = worldChunkTracker;
  }

  /**
   * Hint: See list of all events by opening the call hierarchy of
   * {@link EventFactory#createArrayBacked(Class, java.util.function.Function)}
   */
  public void register() {
    // Standard Events
    ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
      return forwardEventToInterceptors(new ChatMessageEvent(sender, message.method_46291()));
    });
    ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
      forwardEventToCollectors(new ChatMessageEvent(sender, message.method_46291()));
    });
    PlayerBlockBreakEvents.BEFORE.register((class_1937 world, class_1657 player, class_2338 pos,
        class_2680 state, @Nullable class_2586 blockEntity) -> {
      if (!world.method_8608()) {
        boolean result = forwardEvent(
            new BeforePlayerBlockBreakEvent((class_3218) world, player, pos, state, blockEntity));
        return result;
      }
      return true;
    });
    PlayerBlockBreakEvents.AFTER.register((class_1937 world, class_1657 player, class_2338 pos,
        class_2680 state, @Nullable class_2586 blockEntity) -> {
      if (!world.method_8608()) {
        forwardEvent(
            new AfterPlayerBlockBreakEvent((class_3218) world, player, pos, state, blockEntity));
      }
    });
    UseItemCallback.EVENT.register(new UseItemCallback() {
      @Override
      public class_1271<class_1799> interact(class_1657 player, class_1937 world, class_1268 hand) {
        if (!world.method_8608()) {
          class_1799 itemStack = player.method_5998(hand);
          boolean proceed =
              forwardEvent(new PlayerUseItemEvent(player, (class_3218) world, hand, itemStack));
          if (!proceed) {
            return class_1271.method_22431(class_1799.field_8037);
          }
        }
        return class_1271.method_22430(class_1799.field_8037);
      }
    });
    ServerPlayerEvents.AFTER_RESPAWN
        .register((class_3222 oldPlayer, class_3222 newPlayer, boolean alive) -> {
          forwardEvent(new AfterPlayerRespawnEvent(oldPlayer, newPlayer, alive));
        });
    ServerPlayConnectionEvents.JOIN.register(
        (class_3244 handler, PacketSender sender, MinecraftServer server) -> {
          forwardEvent(new PlayerJoinedEvent(handler.method_32311()));
        });
    ServerPlayConnectionEvents.DISCONNECT
        .register((class_3244 handler, MinecraftServer server) -> {
          forwardEvent(new PlayerDisconnectedEvent(handler.method_32311()));
        });
    ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
      return forwardEvent(new BeforeLivingEntityDeathEvent(entity, damageSource, damageAmount));

    });
    ServerLivingEntityEvents.AFTER_DEATH.register((entity,
        damageSource) -> forwardEvent(new AfterLivingEntityDeathEvent(entity, damageSource)));
    UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
      if (world instanceof class_3218 serverWorld) {
        boolean proceed = forwardEvent(
            new PlayerUseBlockEvent((class_3222) player, serverWorld, hand, hitResult));
        if (!proceed) {
          return class_1269.field_5814;
        }
      }
      return class_1269.field_5811;
    });
    AttackEntityCallback.EVENT.register((class_1657 player, class_1937 world, class_1268 hand, class_1297 entity,
        @Nullable class_3966 hitResult) -> {
      if (world instanceof class_3218 serverWorld) {
        boolean proceed = forwardEvent(
            new PlayerAttackEntityEvent((class_3222) player, serverWorld, hand, entity));
        if (!proceed) {
          return class_1269.field_5814;
        }
      }
      return class_1269.field_5811;
    });
    PermissionCheckEvent.EVENT.register((class_2172 source, String permission) -> {
      class_3218 world = null;
      class_1297 entity = null;
      Spell spell = null;
      AtomicReference<Boolean> allowed = new AtomicReference<>(null);
      if (source instanceof class_2168 scs) {
        world = scs.method_9225();
        entity = scs.method_9228();
        spell = null;
        if (source instanceof SpellServerCommandSource sscs) {
          spell = sscs.getSpell();
          entity = spell.getOwner();
        }
      }
      forwardEvent(new net.wizardsoflua.event.PermissionCheckEvent(permission, world, entity, spell,
          allowed));
      TriState result = TriState.of(allowed.get());
      return result;
    });
    ServerChunkEvents.CHUNK_LOAD.register((class_3218 world, class_2818 chunk) -> {
      class_1923 pos = chunk.method_12004();
      worldChunkTracker.add(world, chunk.method_12004());
      forwardEvent(new ChunkLoadEvent(world, pos.field_9181, pos.field_9180));
    });
    ServerChunkEvents.CHUNK_UNLOAD.register((class_3218 world, class_2818 chunk) -> {
      class_1923 pos = chunk.method_12004();
      forwardEvent(new ChunkUnloadEvent(world, pos.field_9181, pos.field_9180));
      worldChunkTracker.remove(world, chunk.method_12004());
    });
    ServerWorldEvents.UNLOAD.register((server, world) -> {
      worldChunkTracker.remove(world);
    });
    ServerLifecycleEvents.SERVER_STOPPED.register(server -> worldChunkTracker.clear());
    // fires when server spawns an entity.
    ServerEntityEvents.ENTITY_LOAD.register((class_1297 entity, class_3218 world) -> {
      forwardEvent(new EntitySpawnEvent(entity));
    });
    // fires when server despawns an entity.
    ServerEntityEvents.ENTITY_UNLOAD.register((class_1297 entity, class_3218 world) -> {
      forwardEvent(new EntityDespawnEvent(entity));
    });
    // fires after a player moves between worlds.
    ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD
        .register((class_3222 player, class_3218 origin, class_3218 destination) -> {
          forwardEvent(new PlayerChangeWorldEvent(player, origin, destination));
        });
    // fires when code checks if entity may take damage.
    ServerLivingEntityEvents.ALLOW_DAMAGE
        .register((class_1309 entity, class_1282 damageSource, float damageAmount) -> {
          return forwardEvent(
              new BeforeLivingEntityDamageEvent(entity, damageSource, damageAmount));
        });
    // fires after an entity takes damage.
    ServerLivingEntityEvents.AFTER_DAMAGE.register((class_1309 entity, class_1282 source,
        float baseDamageTaken, float damageTaken, boolean blocked) -> {
      forwardEvent(
          new AfterLivingEntityDamageEvent(entity, source, baseDamageTaken, damageTaken, blocked));
    });
    // fires when a player attacks a block.
    AttackBlockCallback.EVENT.register(
        (class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) -> {
          if (!world.method_8608()) {
            class_2680 blockState = world.method_8320(pos);
            boolean proceed = forwardEvent(new PlayerAttackBlockEvent((class_3222) player,
                (class_3218) world, blockState, hand, pos, direction));
            if (!proceed) {
              return class_1269.field_5814;
            }
          }
          return class_1269.field_5811;
        });
    // fires when a player interacts with an entity.
    UseEntityCallback.EVENT.register((class_1657 player, class_1937 world, class_1268 hand, class_1297 entity,
        @Nullable class_3966 hitResult) -> {
      if (!world.method_8608()) {
        boolean proceed = forwardEvent(new PlayerUseEntityEvent((class_3222) player,
            (class_3218) world, hand, entity, hitResult));
        if (!proceed) {
          return class_1269.field_5814;
        }
      }
      return class_1269.field_5811;
    });


    // Custom Events
    HandSwingCallback.EVENT.register((class_3222 player, class_1268 hand) -> {
      forwardEvent(new PlayerHandSwingEvent(player, hand));
    });
    PlayerDropItemCallback.EVENT.register((class_3222 player, class_1542 itemEntity) -> {
      forwardEvent(new PlayerDropItemEvent(player, itemEntity));
    });
    PlayerDropSelectedItemCallback.EVENT.register((player, itemStack, entireStack) -> {
      return forwardEvent(new PlayerDropSelectedItemEvent(player, itemStack, entireStack));
    });
    SpellFinishCallback.EVENT.register((Spell spell) -> {
      forwardEvent(new SpellFinishEvent(spell));
    });
  }

  private boolean forwardEvent(WolEvent event) {
    String eventName = event.getClass().getSimpleName();
    return spellRegistry.forwardEvent(eventName, event, EventHandlerType.BOTH);
  }

  private boolean forwardEventToInterceptors(WolEvent event) {
    String eventName = event.getClass().getSimpleName();
    return spellRegistry.forwardEvent(eventName, event, EventHandlerType.INTERCEPTORS);
  }

  private boolean forwardEventToCollectors(WolEvent event) {
    String eventName = event.getClass().getSimpleName();
    return spellRegistry.forwardEvent(eventName, event, EventHandlerType.COLLECTORS);
  }
}
