package net.wizardsoflua.lua.classes;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.wizardsoflua.event.AfterLivingEntityDeathEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaAfterLivingEntityDeathEvent< //
    J extends AfterLivingEntityDeathEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<AfterLivingEntityDeathEvent, LuaAfterLivingEntityDeathEvent<AfterLivingEntityDeathEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("AfterLivingEntityDeathEvent", spellScope, null);
    }

    @Override
    protected final LuaAfterLivingEntityDeathEvent<AfterLivingEntityDeathEvent, Class> createNewLuaInstance(
        AfterLivingEntityDeathEvent javaInstance) {
      return new LuaAfterLivingEntityDeathEvent<>(this, javaInstance);
    }
  }

  public LuaAfterLivingEntityDeathEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
    addReadOnly("damageSource", this::getDamageSource);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1309 result = getDelegate().entity();
    return getConverters().toLua(result);
  }

  private Object getDamageSource() {
    class_1282 result = getDelegate().damageSource();
    return getConverters().toLua(result);
  }
}
