package net.wizardsoflua.lua.classes;

import net.minecraft.class_3218;
import net.wizardsoflua.event.ChunkLoadEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaChunkLoadEvent< //
    J extends ChunkLoadEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<ChunkLoadEvent, LuaChunkLoadEvent<ChunkLoadEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("ChunkLoadEvent", spellScope, null);
    }

    @Override
    protected final LuaChunkLoadEvent<ChunkLoadEvent, Class> createNewLuaInstance(
        ChunkLoadEvent javaInstance) {
      return new LuaChunkLoadEvent<>(this, javaInstance);
    }
  }

  public LuaChunkLoadEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("chunkX", this::getChunkX);
    addReadOnly("chunkZ", this::getChunkZ);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    class_3218 result = getDelegate().world();
    return getConverters().toLuaNullable(result);
  }

  private Object getChunkX() {
    int result = getDelegate().chunkX();
    return getConverters().toLua(result);
  }

  private Object getChunkZ() {
    int result = getDelegate().chunkZ();
    return getConverters().toLua(result);
  }
}
