package net.wizardsoflua.lua.classes;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.spell.SpellScope;

public class LuaItem< //
    J extends class_1799, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<class_1799, LuaItem<class_1799, Class>> {
    public static final String NAME = "Item";

    public Class(SpellScope spellScope) {
      super(NAME, spellScope, null);
      addFunction(new NewFunction());
      addFunction(new PutNbtFunction());
      addFunction(new CopyFunction());
    }

    @Override
    protected final LuaItem<class_1799, Class> createNewLuaInstance(class_1799 javaInstance) {
      return new LuaItem<>(this, javaInstance);
    }

    private class NewFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "new";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        @SuppressWarnings("unused")
        Table self = getConverters().castTo(Table.class, arg1, 1, "self", getName());
        String id = getConverters().toJava(String.class, arg2, 2, "id", getName());
        Table nbt = getConverters().castToOptional(Table.class, arg3, 3, "nbt", getName())
            .orElse(new DefaultTable());
        class_1792 item = class_7923.field_41178.method_10223(class_2960.method_60654(id));
        class_1799 itemStack = item.method_7854();
        itemStack = putNbt(itemStack, nbt);
        Object result = getConverters().toLua(itemStack);
        context.getReturnBuffer().setTo(result);
      }
    }

    class PutNbtFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "putNbt";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        @SuppressWarnings("unchecked")
        LuaItem<class_1799, ?> self =
            getConverters().toJava(LuaItem.class, arg1, 1, "self", getName());
        Table nbt = getConverters().castTo(Table.class, arg2, 2, "nbt", getName());
        class_1799 itemStack = self.getDelegate();
        itemStack = putNbt(itemStack, nbt);
        self.setDelegate(itemStack);
        context.getReturnBuffer().setTo();
      }
    }

    private class_1799 putNbt(class_1799 itemStack, Table data) {
      class_5455 registryManager = getWorld().method_30349();
      class_2487 oldNbt = getNbt(itemStack, registryManager);
      class_2487 newNbt = getNbtConverter().merge(oldNbt, data);
      Optional<class_1799> result = class_1799.method_57360(registryManager, newNbt);
      if (result.isPresent()) {
        return result.get();
      } else {
        throw new IllegalArgumentException("Can't build item stack from given nbt.");
      }
    }

    class CopyFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "copy";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        @SuppressWarnings("unchecked")
        LuaItem<class_1799, ?> self =
            getConverters().toJava(LuaItem.class, arg1, 1, "self", getName());
        class_1799 itemStack = self.getDelegate();
        class_1799 result = itemStack.method_7972();
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }
    }
  }

  public LuaItem(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("type", this::getType);
    add("count", this::getCount, this::setCount);
    addReadOnly("maxCount", this::getMaxCount);
    addReadOnly("stackable", this::isStackable);
    add("name", this::getName, this::setName);
    addReadOnly("maxDamage", this::getMaxDamage);
    add("damage", this::getDamage, this::setDamage);
    add("nbt", this::getNbt, this::setNbt);
  }

  private Object getType() {
    class_1792 item = getDelegate().method_7909();
    return getConverters().toLua(item);
  }

  private Object getCount() {
    return getConverters().toLua(getDelegate().method_7947());
  }

  private void setCount(Object object) {
    int count = getConverters().toJava(int.class, object, "count");
    getDelegate().method_7939(count);
  }

  private Object getMaxCount() {
    return getConverters().toLua(getDelegate().method_7914());
  }

  private Object isStackable() {
    return getConverters().toLua(getDelegate().method_7946());
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().method_7964());
  }

  private void setName(Object object) {
    Optional<String> name = getConverters().toJavaOptional(String.class, object, "name");
    setName(getDelegate(), name);
  }

  public static void setName(class_1799 itemStack, Optional<String> name) {
    class_2561 text = name.map(class_2561::method_30163).orElse(null);
    itemStack.method_57379(class_9334.field_49631, text);
  }

  private Object getMaxDamage() {
    return getConverters().toLua(getDelegate().method_7936());
  }

  private Object getDamage() {
    return getConverters().toLua(getDelegate().method_7919());
  }

  private void setDamage(Object object) {
    int damage = getConverters().toJava(int.class, object, "damage");
    getDelegate().method_7974(damage);
  }

  private Object getNbt() {
    J itemStack = getDelegate();
    class_5455 registryManager = getLuaClass().getWorld().method_30349();
    class_2520 result = getNbt(itemStack, registryManager);
    return NbtConverter.toLua(result);
  }

  private static class_2487 getNbt(class_1799 itemStack, class_5455 registryManager) {
    if (itemStack.method_7960()) {
      return new class_2487();
    }
    class_2520 result = itemStack.method_57358(registryManager);
    return (class_2487) result;
  }

  @SuppressWarnings("unchecked")
  private void setNbt(Object luaObject) {
    Table data = getConverters().toJava(Table.class, luaObject, "nbt");
    class_5455 registryManager = getLuaClass().getWorld().method_30349();
    class_2487 newNbt = getLuaClass().getNbtConverter().merge(new class_2487(), data);
    var newStack = class_1799.method_57360(registryManager, newNbt);
    if (newStack.isPresent()) {
      setDelegate((J) newStack.get());
    } else {
      throw new IllegalArgumentException("Can't build item stack from given nbt.");
    }
  }
}
