package net.wizardsoflua.lua.classes;

import static java.util.Objects.requireNonNull;
import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.spell.SpellScope;

public class LuaItemEntity< //
    J extends class_1542, //
    LC extends AbstractLuaClass<?, ?> //
> extends LuaEntity<J, LC> {

  public static class Class extends AbstractLuaClass<class_1542, LuaItemEntity<class_1542, net.wizardsoflua.lua.classes.LuaItemEntity.Class>> {
    public Class(SpellScope spellScope, LuaEntity.Class luaSuperclass) {
      super("ItemEntity", spellScope, luaSuperclass);
      addFunction(new NewFunction(spellScope));
    }

    @Override
    protected final LuaItemEntity<class_1542, net.wizardsoflua.lua.classes.LuaItemEntity.Class> createNewLuaInstance(class_1542 javaInstance) {
      return new LuaItemEntity<>(this, javaInstance);
    }

    private class NewFunction extends NamedFunction3 {
      private SpellScope spellScope;

      public NewFunction(SpellScope spellScope) {
        this.spellScope = requireNonNull(spellScope, "spellScope");
      }

      @Override
      public String getName() {
        return "new";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        @SuppressWarnings("unused")
        LuaItemEntity.Class self =
            getConverters().castTo(LuaItemEntity.Class.class, arg1, 1, "self", getName());
        LuaItem<?, ?> item = getConverters().castTo(LuaItem.class, arg2, 2, "item", getName());
        Table nbt = getConverters().castToOptional(Table.class, arg3, 3, "nbt", getName())
            .orElse(new DefaultTable());
        class_1799 itemStack = item.getDelegate();
        class_3218 world = spellScope.getWorld();
        class_243 pos = spellScope.getSpell().getPos();
        double x = pos.method_10216();
        double y = pos.method_10214();
        double z = pos.method_10215();
        class_1542 itemEntity = new class_1542(world, x, y, z, itemStack);
        itemEntity.method_6988();
        LuaEntity.putNbt(itemEntity, getNbtConverter(), nbt);
        world.method_8649(itemEntity);
        Object result = getConverters().toLua(itemEntity);
        context.getReturnBuffer().setTo(result);
      }
    }
  }

  public LuaItemEntity(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance);
    addReadOnly("owner", this::getOwner);
    addReadOnly("itemAge", this::getItemAge);
    add("item", this::getItem, this::setItem);
  }

  private Object getOwner() {
    return getConverters().toLuaNullable(getDelegate().method_24921());
  }

  private Object getItemAge() {
    return getConverters().toLuaNullable(getDelegate().method_6985());
  }

  private Object getItem() {
    return getConverters().toLuaNullable(getDelegate().method_6983());
  }

  private void setItem(Object luaObject) {
    class_1799 itemStack = getConverters().toJava(class_1799.class, luaObject, "item");
    getDelegate().method_6979(itemStack);
  }

  @Override
  protected Object getName() {
    class_1799 stack = getDelegate().method_6983();
    return getConverters().toLuaNullable(stack.method_7964());
  }

  @Override
  protected void setName(Object luaObject) {
    Optional<String> name = getConverters().toJavaOptional(String.class, luaObject, "name");
    LuaItem.setName(getDelegate().method_6983(), name);
  }
}
