package net.wizardsoflua.lua.classes;

import com.google.common.collect.ImmutableSet;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction5;
import net.wizardsoflua.mixin.impls.EntityNavigationAccessor;
import net.wizardsoflua.spell.SpellScope;

public class LuaMobEntity< //
    J extends class_1308, //
    LC extends AbstractLuaClass<?, ?> //
> extends LuaLivingEntity<J, LC> {

  public static class Class extends AbstractLuaClass<class_1308, LuaMobEntity<class_1308, net.wizardsoflua.lua.classes.LuaMobEntity.Class>> {
    public Class(SpellScope spellScope, LuaLivingEntity.Class luaSuperclass) {
      super("MobEntity", spellScope, luaSuperclass);
      addFunction(new StartFollowPathToFunction());
      addFunction(new StopFollowPathFunction());
    }

    @Override
    protected LuaMobEntity<class_1308, net.wizardsoflua.lua.classes.LuaMobEntity.Class> createNewLuaInstance(class_1308 javaInstance) {
      return new LuaMobEntity<>(this, javaInstance);
    }

    class StartFollowPathToFunction extends NamedFunction5 {
      @Override
      public String getName() {
        return "startFollowPathTo";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3,
          Object arg4, Object arg5) throws ResolvedControlThrowable {
        LuaMobEntity<?, ?> self =
            getConverters().toJava(LuaMobEntity.class, arg1, 1, "self", getName());
        class_243 target = getConverters().toJava(class_243.class, arg2, 2, "target", getName());
        int targetRadius = getConverters()
            .toJavaOptional(Integer.class, arg3, 3, "targetRadius", getName()).orElse(50);
        int searchRange = getConverters()
            .toJavaOptional(Integer.class, arg4, 4, "searchRange", getName()).orElse(50);
        float speed =
            getConverters().toJavaOptional(Float.class, arg5, 5, "speed", getName()).orElse(1f);
        class_1308 entity = self.getDelegate();
        boolean result = startFollowPathTo(entity, target, targetRadius, searchRange, speed);
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }

      private boolean startFollowPathTo(class_1308 entity, class_243 target, int targetRadius,
          int searchRange, float speed) {
        entity.method_35056();
        entity.method_18868().method_49709();
        entity.method_24830(true);
        class_1408 navigation = entity.method_5942();
        class_11 path = findPathToTarget(navigation, target, targetRadius, searchRange);
        return navigation.method_6334(path, speed);
      }

      private class_11 findPathToTarget(class_1408 navigation, class_243 target, int targetRadius,
          int searchRange) {
        EntityNavigationAccessor accessor = (EntityNavigationAccessor) navigation;
        boolean useHeadPos = false;
        int distance = targetRadius;
        float followRange = searchRange;
        ImmutableSet<class_2338> positions = ImmutableSet.of(class_2338.method_49638(target));
        int range = 0;
        return accessor.callFindPathToAny(positions, range, useHeadPos, distance, followRange);
      }
    }

    class StopFollowPathFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "stopFollowPath";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        LuaMobEntity<?, ?> self =
            getConverters().toJava(LuaMobEntity.class, arg1, 1, "self", getName());
        class_1308 entity = self.getDelegate();
        entity.method_5942().method_6340();
        context.getReturnBuffer().setTo();
      }
    }
  }

  public LuaMobEntity(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance);
    addReadOnly("followingPath", () -> isFollowingPath());
  }

  private Object isFollowingPath() {
    boolean isFollowingPath = getDelegate().method_5942().method_23966();
    return getConverters().toLua(isFollowingPath);
  }
}
