package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerAttackEntityEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerAttackEntityEvent< //
    J extends PlayerAttackEntityEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerAttackEntityEvent, LuaPlayerAttackEntityEvent<PlayerAttackEntityEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerAttackEntityEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerAttackEntityEvent<PlayerAttackEntityEvent, Class> createNewLuaInstance(
        PlayerAttackEntityEvent javaInstance) {
      return new LuaPlayerAttackEntityEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerAttackEntityEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("world", this::getWorld);
    addReadOnly("hand", this::getHand);
    addReadOnly("entity", this::getEntity);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getWorld() {
    class_1937 result = getDelegate().world();
    return getConverters().toLua(result);
  }

  private Object getHand() {
    class_1268 result = getDelegate().hand();
    return getConverters().toLua(result);
  }

  private Object getEntity() {
    class_1297 result = getDelegate().entity();
    return getConverters().toLua(result);
  }
}
