package net.wizardsoflua.lua.classes;

import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.spell.CommandTrace;
import net.wizardsoflua.spell.SpellScope;

public class LuaTrace< //
    J extends CommandTrace, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<CommandTrace, LuaTrace<CommandTrace, Class>> {
    public Class(SpellScope spellScope) {
      super("Trace", spellScope, null);
      addFunction(new NewFunction());
    }

    @Override
    protected final LuaTrace<CommandTrace, Class> createNewLuaInstance(CommandTrace javaInstance) {
      return new LuaTrace<>(this, javaInstance);
    }
    
    private class NewFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "new";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1)
          throws ResolvedControlThrowable {
        @SuppressWarnings("unused")
        Table self = getConverters().castTo(Table.class, arg1, 1, "self", getName());
        Object result = getConverters().toLua(new CommandTrace());
        context.getReturnBuffer().setTo(result);
      }
    }
  }

  public LuaTrace(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("content", this::getContent);
  }

  private Object getContent() {
    return getConverters().toLuaNullable(getDelegate().getContentAsString());
  }
}
