package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2481;

public class NbtByteMerger implements NbtMerger<class_2481> {
  private final NbtConverter converter;

  public NbtByteMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2481 merge(class_2481 nbt, Object data, String key, String path) {
    if (data instanceof Boolean) {
      return NbtConverter.toNbt((Boolean) data);
    }
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).byteValue());
    }
    throw converter.conversionException(path, data, "boolean/number");
  }
}
