package net.wizardsoflua.mixin.impls;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerDropItemCallback;

@Mixin(class_1657.class)
public class PlayerEntityMixin {
  @Inject(method = "dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;",
      at = @At("RETURN"))
  private void onDropItem(class_1799 stack, boolean throwRandomly, boolean retainOwnership,
      CallbackInfoReturnable<class_1542> cir) {
    if ((Object) this instanceof class_3222 player) {
      class_1542 itemEntity = cir.getReturnValue();
      if (itemEntity != null) {
        PlayerDropItemCallback.EVENT.invoker().onDropItem(player, itemEntity);
      }
    }
  }
}
