package net.wizardsoflua.spell;

import java.util.Collection;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SpellAuraFX {
  private static class State {
    final class_2394 type;
    final float speed;
    final double offset;
    final boolean longDistance;

    public State(class_2394 type, float speed, double offset, boolean longDistance) {
      this.type = type;
      this.speed = speed;
      this.offset = offset;
      this.longDistance = longDistance;
    }
  }

  private static final State[] STATES = {new State(class_2398.field_11204, 0, 0.1, true),
      new State(class_2390.field_11188, 0, 0.4, false),
      new State(class_2398.field_11249, 1, 0, false),
      new State(class_2398.field_11219, 0, 0.12, false)};

  public static void spawnParticle(Spell spell) {
    long time = spell.getAge();
    if (time % 2 > 0) {
      return;
    }
    time = time / 2;
    spawnParticle(spell, spell.getPos(), time);
  }

  private static void spawnParticle(Spell spell, class_243 pos, long time) {
    class_3218 world = spell.getWorld();

    State state = STATES[(int) (time % STATES.length)];
    class_2394 particleEffect = state.type;
    double offset = state.offset;
    double offsetX = offset;
    double offsetY = offset;
    double offsetZ = offset;
    float particleSpeed = state.speed;
    int numberOfParticles = 2;
    boolean force = state.longDistance;
    Collection<class_3222> viewers = world.method_8503().method_3760().method_14571();
    spawnParticle(world, particleEffect, pos.field_1352, pos.field_1351, pos.field_1350, offsetX, offsetY, offsetZ,
        particleSpeed, numberOfParticles, force, viewers);
  }

  /**
   * Spawns particles at the given location.
   *
   * @param world
   * @param particleData
   * @param x
   * @param y
   * @param z
   * @param offsetX
   * @param offsetY
   * @param offsetZ
   * @param particleSpeed
   * @param numberOfParticles
   * @param force
   * @param viewers
   *
   * @see net.minecraft.command.impl.ParticleCommand.spawnParticle
   */
  private static <T extends class_2394> void spawnParticle(class_3218 world, T particleEffect,
      double x, double y, double z, double offsetX, double offsetY, double offsetZ,
      float particleSpeed, int numberOfParticles, boolean force,
      Collection<class_3222> viewers) {

    for (class_3222 viewer : viewers) {
      if (world.method_14166(viewer, particleEffect, force, x, y, z, numberOfParticles, offsetX,
          offsetY, offsetZ, (double) particleSpeed)) {
      }
    }
  }
}
