package net.wizardsoflua.chunk;

import static com.google.common.base.Preconditions.checkNotNull;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class ChunkForceManager {

  private class WorldManager {
    private final class_3218 world;

    public WorldManager(class_3218 world) {
      this.world = checkNotNull(world, "world == null!");
    }

    private final Map<class_1923, ChunkForce> chunkForces = new HashMap<>();

    public ChunkForce getChunkForce(class_1923 chunkPos) {
      return chunkForces.computeIfAbsent(chunkPos, key -> new ChunkForce(world, chunkPos));
    }
  }

  private final Map<class_1937, WorldManager> managers = new HashMap<>();

  public void forceChunk(Ticket ticket, class_1923 chunkPos) {
    WorldManager m = getManager(ticket.getWorld());
    ChunkForce chunkForce = m.getChunkForce(chunkPos);
    if (chunkForce.add(ticket)) {
      ticket.add(chunkForce);
    }
  }

  public void unforceChunk(Ticket ticket, class_1923 chunkPos) {
    WorldManager m = getManager(ticket.getWorld());
    ChunkForce chunkForce = m.getChunkForce(chunkPos);
    if (chunkForce.remove(ticket)) {
      ticket.remove(chunkForce);
    }
  }

  private WorldManager getManager(class_3218 world) {
    return managers.computeIfAbsent(world, key -> new WorldManager(world));
  }

}
