package net.wizardsoflua.command.dynamic;

import java.util.List;

/**
 * A single piece of a dynamic‐command pattern: either a literal word or a placeholder.
 *
 * @param raw the original token text, e.g. "foo:%d", "%item", or "baz"
 * @param isPlaceholder true if this token represents a %… placeholder
 * @param name the placeholder’s name (null for unnamed placeholders & literals)
 * @param placeholderType the placeholder type enum (null for literal tokens)
 * @param enumValues if non-null, the allowed values for a %s[...] enum‐placeholder
 */
public record Token(String raw, boolean isPlaceholder, String name, String node,
    Placeholder placeholder, List<String> enumValues) {
  /** @return true if this is a named placeholder (i.e. isPlaceholder && name != null) */
  public boolean isNamed() {
    return isPlaceholder && name != null;
  }
}
