package net.wizardsoflua.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public interface PlayerDropSelectedItemCallback {
  Event<PlayerDropSelectedItemCallback> EVENT = EventFactory.createArrayBacked(
      PlayerDropSelectedItemCallback.class, listeners -> (player, stack, entireStack) -> {
        for (PlayerDropSelectedItemCallback callback : listeners) {
          boolean proceed = callback.onDropSelectedItem(player, stack, entireStack);
          if (!proceed) {
            return false;
          }
        }
        return true;
      });

  boolean onDropSelectedItem(class_3222 player, class_1799 itemStack, boolean entireStack);
}
