package net.wizardsoflua.lua.classes;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.wizardsoflua.event.AfterLivingEntityDamageEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaAfterLivingEntityDamageEvent< //
    J extends AfterLivingEntityDamageEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<AfterLivingEntityDamageEvent, LuaAfterLivingEntityDamageEvent<AfterLivingEntityDamageEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("AfterLivingEntityDamageEvent", spellScope, null);
    }

    @Override
    protected final LuaAfterLivingEntityDamageEvent<AfterLivingEntityDamageEvent, Class> createNewLuaInstance(
        AfterLivingEntityDamageEvent javaInstance) {
      return new LuaAfterLivingEntityDamageEvent<>(this, javaInstance);
    }
  }

  public LuaAfterLivingEntityDamageEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
    addReadOnly("damageSource", this::getDamageSource);
    addReadOnly("damageDealt", this::getDamageDealt);
    addReadOnly("damageTaken", this::getDamageTaken);
    addReadOnly("blocked", this::isBlocked);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1309 result = getDelegate().entity();
    return getConverters().toLua(result);
  }

  private Object getDamageSource() {
    class_1282 result = getDelegate().damageSource();
    return getConverters().toLua(result);
  }

  private Object getDamageDealt() {
    float result = getDelegate().damageDealt();
    return getConverters().toLua(result);
  }

  private Object getDamageTaken() {
    float result = getDelegate().damageTaken();
    return getConverters().toLua(result);
  }

  private Object isBlocked() {
    boolean result = getDelegate().blocked();
    return getConverters().toLua(result);
  }
}
