package net.wizardsoflua.lua.classes;

import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.block.BlockPropertyConverter;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.table.PropertyTable;
import net.wizardsoflua.spell.SpellScope;

public class LuaBlock< //
    J extends class_2680, //
    LC extends LuaBlock.Class //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<class_2680, LuaBlock<class_2680, Class>> {
    public Class(SpellScope spellScope) {
      super("Block", spellScope, null);
      addFunction(new NewFunction());
    }

    @Override
    protected final LuaBlock<class_2680, Class> createNewLuaInstance(class_2680 javaInstance) {
      return new LuaBlock<>(this, javaInstance);
    }

    private class NewFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "new";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        @SuppressWarnings("unused")
        Table self = getConverters().toJava(Table.class, arg1, 1, "self", getName());
        String id = getConverters().toJava(String.class, arg2, 2, "id", getName());
        class_2248 block = class_7923.field_41175.method_63535(class_2960.method_60654(id));
        class_2680 blockState = block.method_9564();
        Object result = getConverters().toLua(blockState);
        context.getReturnBuffer().setTo(result);
      }
    }
  }

  public LuaBlock(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("type", this::getBlockType);
    addReadOnly("luminance", this::getLuminance);
    addReadOnly("burnable", this::isBurnable);
    addReadOnly("opaque", this::isOpaque);
    addReadOnly("toolRequired", this::isToolRequired);
    addDataProperties();
  }

  private void addDataProperties() {
    PropertyTable data = new PropertyTable(true);
    addReadOnly("data", () -> data);
    for (class_2769<?> property : getDelegate().method_28501()) {
      data.add(property.method_11899(), () -> getValue(property), (it) -> setValue(property, it));
    }
  }

  @SuppressWarnings("unchecked")
  private <P extends Comparable<P>> void setValue(class_2769<P> property, Object luaValue) {
    class_2680 blockState = getDelegate();
    P value = BlockPropertyConverter.toJava(property.method_11902(), luaValue);
    class_2680 newDelegate = blockState.method_11657(property, value);
    setDelegate((J) newDelegate);
  }

  private Object getValue(class_2769<?> property) {
    class_2680 blockState = getDelegate();
    return BlockPropertyConverter.toLua(blockState.method_11654(property));
  }

  private Object getBlockType() {
    return getConverters().toLua(getDelegate().method_26204());
  }

  private Object getLuminance() {
    return getConverters().toLua(getDelegate().method_26213());
  }

  private Object isBurnable() {
    return getConverters().toLua(getDelegate().method_50011());
  }

  private Object isOpaque() {
    return getConverters().toLua(getDelegate().method_26225());
  }

  private Object isToolRequired() {
    return getConverters().toLua(getDelegate().method_29291());
  }
}
