package net.wizardsoflua.lua.classes;

import net.wizardsoflua.event.CustomEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaCustomEvent< //
    J extends CustomEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<CustomEvent, LuaCustomEvent<CustomEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("CustomEvent", spellScope, null);
    }

    @Override
    protected final LuaCustomEvent<CustomEvent, Class> createNewLuaInstance(
        CustomEvent javaInstance) {
      return new LuaCustomEvent<>(this, javaInstance);
    }
  }

  public LuaCustomEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("data", this::getData);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().name());
  }

  private Object getData() {
    return getConverters().toLuaNullable(getDelegate().data());
  }
}
