package net.wizardsoflua.lua.classes;

import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.module.event.EventInterceptor;
import net.wizardsoflua.spell.SpellScope;

public class LuaEventInterceptor< //
    J extends EventInterceptor, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<EventInterceptor, LuaEventInterceptor<EventInterceptor, Class>> {
    public Class(SpellScope spellScope) {
      super("EventInterceptor", spellScope, null);
      addFunction(new StopFunction());
    }

    @Override
    protected final LuaEventInterceptor<EventInterceptor, Class> createNewLuaInstance(
        EventInterceptor javaInstance) {
      return new LuaEventInterceptor<>(this, javaInstance);
    }

    private class StopFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "stop";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        EventInterceptor self =
            getConverters().toJava(EventInterceptor.class, arg1, 1, "self", getName());
        self.stop();
        context.getReturnBuffer().setTo();
      }
    }
  }

  public LuaEventInterceptor(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("names", this::getNames);
  }

  private Object getNames() {
    return getConverters().toLua(getDelegate().getNames());
  }
}
