package net.wizardsoflua.lua.classes;

import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

public class LuaInstanceCache {
  private final Cache<Object, Object> cache =
      CacheBuilder.newBuilder().weakKeys().softValues().build();

  public <L, J> L getOrCreate(J javaInstance, Function<J, L> toLuaMapper) {
    @SuppressWarnings("unchecked")
    ConcurrentMap<J, L> map = (ConcurrentMap<J, L>) cache.asMap();
    return map.computeIfAbsent(javaInstance, toLuaMapper::apply);
  }

  public <J> boolean replaceKey(J oldKey, J newKey) {
    Object value = cache.getIfPresent(oldKey);
    if (value != null) {
      cache.invalidate(oldKey);
      cache.put(newKey, value);
      return true;
    }
    return false;
  }
}
