package net.wizardsoflua.lua.classes;

import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.wizardsoflua.event.PermissionCheckEvent;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellScope;

public class LuaPermissioCheckEvent< //
    J extends PermissionCheckEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<PermissionCheckEvent, LuaPermissioCheckEvent<PermissionCheckEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PermissionCheckEvent", spellScope, null);
    }

    @Override
    protected final LuaPermissioCheckEvent<PermissionCheckEvent, Class> createNewLuaInstance(
        PermissionCheckEvent javaInstance) {
      return new LuaPermissioCheckEvent<>(this, javaInstance);
    }
  }

  public LuaPermissioCheckEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("permission", this::getPermission);
    addReadOnly("world", this::getWorld);
    addReadOnly("entity", this::getEntity);
    addReadOnly("spell", this::getSpell);
    add("allowed", this::getAllowed, this::setAllowed);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }
  
  private Object getPermission() {
    return getConverters().toLua(getDelegate().permission());
  }

  private Object getWorld() {
    class_3218 result = getDelegate().world();
    return getConverters().toLuaNullable(result);
  }
  
  private Object getEntity() {
    class_1297 result = getDelegate().entity();
    return getConverters().toLuaNullable(result);
  }
  
  private Object getSpell() {
    Spell result = getDelegate().spell();
    return getConverters().toLuaNullable(result);
  }
  
  private Object getAllowed() {
    Boolean result = getDelegate().allowed().get();
    return getConverters().toLuaNullable(result);
  }
  
  private void setAllowed(Object luaObject) {
    Boolean value = getConverters().toJavaNullable(Boolean.class, luaObject, "allowed");
    getDelegate().allowed().set(value);
  }
}
