package net.wizardsoflua.lua.classes;

import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerChangeWorldEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerChangeWorldEvent< //
    J extends PlayerChangeWorldEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerChangeWorldEvent, LuaPlayerChangeWorldEvent<PlayerChangeWorldEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerChangeWorldEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerChangeWorldEvent<PlayerChangeWorldEvent, Class> createNewLuaInstance(
        PlayerChangeWorldEvent javaInstance) {
      return new LuaPlayerChangeWorldEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerChangeWorldEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("origin", this::getOrigin);
    addReadOnly("destination", this::getDestination);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getOrigin() {
    class_3218 result = getDelegate().origin();
    return getConverters().toLua(result);
  }

  private Object getDestination() {
    class_3218 result = getDelegate().destination();
    return getConverters().toLua(result);
  }
}
