package net.wizardsoflua.lua.classes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.impl.NonsuspendableFunctionException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.CustomEvent;
import net.wizardsoflua.lua.RaycastUtil;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.lua.function.NamedFunction4;
import net.wizardsoflua.lua.function.NamedFunctionAnyArg;
import net.wizardsoflua.lua.module.event.EventInterceptor;
import net.wizardsoflua.lua.module.event.EventQueue;
import net.wizardsoflua.lua.scheduling.LuaScheduler;
import net.wizardsoflua.lua.table.TableUtils;
import net.wizardsoflua.spell.CommandTrace;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.util.WolDirection;

public class LuaSpell< //
    J extends Spell, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<Spell, LuaSpell<Spell, Class>> {
    public Class(SpellScope spellScope) {
      super("Spell", spellScope, null);
      addFunction(new ExecuteFunction());
      addFunction(new ExecuteSilentFunction());
      addFunction(new SleepFunction());
      addFunction(new SummonFunction());
      addFunction(new FindEntitiesFunction());
      addFunction(new FindSpellsFunction());
      addFunction(new CollectFunction());
      addFunction(new InterceptFunction());
      addFunction(new RaycastBlockFunction());
      addFunction(new RaycastEntityFunction());
      addFunction(new RaycastFunction());
      addFunction(new FireFunction());
      addFunction(new KillFunction());
      addFunction(new MoveFunction());
      addFunction(new EvaluateFunction());
      addFunction(new CopyStructureFunction());
      addFunction(new PasteStructureFunction());
      addFunction(new SetYawFunction());
    }

    @Override
    protected final LuaSpell<Spell, Class> createNewLuaInstance(Spell javaInstance) {
      return new LuaSpell<>(this, javaInstance);
    }

    class ExecuteFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "execute";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String cmdStr = getConverters().toJavaNullable(String.class, arg2, 2, "command", getName());
        CommandTrace trace =
            getConverters().toJavaNullable(CommandTrace.class, arg3, 3, "trace", getName());
        Spell spell = self.getDelegate();
        int result = spell.execute(cmdStr, getCommandOutput(spell, trace));
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }

      private class_2165 getCommandOutput(Spell spell, @Nullable CommandTrace trace) {
        class_2168 origCommandSource = spell.getSpellScope().getCommandSource();
        return new class_2165() {
          @Override
          public boolean method_9202() {
            return true;
          }

          @Override
          public boolean method_9200() {
            return true;
          }

          @Override
          public boolean method_9201() {
            return false;
          }

          @Override
          public void method_43496(class_2561 text) {
            origCommandSource.method_9226(() -> text, false);
            if (trace != null) {
              trace.add(text);
            }
          }
        };
      }
    }

    class ExecuteSilentFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "executeSilent";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String cmdStr = getConverters().toJavaNullable(String.class, arg2, 2, "command", getName());
        CommandTrace trace =
            getConverters().toJavaNullable(CommandTrace.class, arg3, 3, "trace", getName());
        Spell spell = self.getDelegate();
        int result = spell.execute(cmdStr, getCommandOutput(trace));
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }

      private class_2165 getCommandOutput(@Nullable CommandTrace trace) {
        return new class_2165() {
          @Override
          public boolean method_9202() {
            return true;
          }

          @Override
          public boolean method_9200() {
            return trace != null;
          }

          @Override
          public boolean method_9201() {
            return false;
          }

          @Override
          public void method_43496(class_2561 text) {
            if (trace != null) {
              trace.add(text);
            }
          }
        };
      }
    }

    class SleepFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "sleep";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        Integer ticks = getConverters().toJavaNullable(Integer.class, arg2, 2, "ticks", getName());
        try {
          Spell spell = self.getDelegate();
          sleep(context, spell, ticks);
        } catch (UnresolvedControlThrowable t) {
          throw t.resolve(this, null);
        }
        execute(context);
      }

      @Override
      public void resume(ExecutionContext context, Object suspendedState)
          throws ResolvedControlThrowable {
        execute(context);
      }

      private void execute(ExecutionContext context) {
        context.getReturnBuffer().setTo();
      }

      public void sleep(ExecutionContext context, Spell spell, @Nullable Integer ticks)
          throws UnresolvedControlThrowable {
        LuaScheduler scheduler = spell.getProgram().getScheduler();
        long sleepTrigger = spell.getProgram().getLuaTicksLimit() / 2;
        if (ticks == null) {
          if (scheduler.getAllowance() < sleepTrigger) {
            ticks = 1;
          } else {
            return;
          }
        }
        if (ticks < 0) {
          throw new IllegalOperationAttemptException("attempt to sleep a negative amount of ticks");
        }
        scheduler.sleep(context, ticks);
      }
    }

    class SummonFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "summon";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String entityTypeName =
            getConverters().toJavaNullable(String.class, arg2, 2, "entityTypeName", getName());

        Spell spell = self.getDelegate();
        class_3218 world = spell.getWorld();

        Table nbtTable =
            getConverters().toJavaNullable(Table.class, arg3, 3, "nbtTable", getName());
        if (nbtTable == null) {
          nbtTable = context.newTable();
        } else {
          nbtTable = TableUtils.copy(nbtTable, context);
        }
        nbtTable.rawset("id", entityTypeName);

        class_2487 nbt = getNbtConverter().toNbtCompound(nbtTable);
        class_243 pos = spell.getPos();
        if (nbtTable.rawget("Pos") instanceof Table t) {
          Object v1 = t.rawget(1);
          Object v2 = t.rawget(2);
          Object v3 = t.rawget(3);
          if (v1 instanceof Number n1 && v2 instanceof Number n2 && v3 instanceof Number n3) {
            pos = new class_243(n1.doubleValue(), n2.doubleValue(), n3.doubleValue());
          }
        }
        class_243 initPos = pos;
        class_1297 entity = class_1299.method_71371(nbt, world, class_3730.field_16462, e -> {
          e.method_5808(initPos.field_1352, initPos.field_1351, initPos.field_1350, e.method_36454(), e.method_36455());
          return e;
        });
        class_5425 serverWorldAcces = world;
        class_1266 difficulty = world.method_8404(entity.method_24515());
        if (entity instanceof class_1308 mobEntity) {
          mobEntity.method_5943(serverWorldAcces, difficulty, class_3730.field_16462, null);
        }
        if (!world.method_30736(entity)) {
          throw new RuntimeException(
              new SimpleCommandExceptionType(class_2561.method_43471("commands.summon.failed")).create());
        }
        Object result = getConverters().toLuaNullable(entity);
        context.getReturnBuffer().setTo(result);
      }

      @Override
      public void resume(ExecutionContext context, Object suspendedState)
          throws ResolvedControlThrowable {
        throw new NonsuspendableFunctionException(this.getClass());
      }
    }

    class FindEntitiesFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "findEntities";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String selector = getConverters().toJava(String.class, arg2, 2, "selector", getName());
        Spell spell = self.getDelegate();
        List<? extends class_1297> entities = find(spell, selector);
        Object luaResult = getConverters().toLuaNullable(entities);
        context.getReturnBuffer().setTo(luaResult);
      }

      @Override
      public void resume(ExecutionContext context, Object suspendedState)
          throws ResolvedControlThrowable {
        throw new NonsuspendableFunctionException(this.getClass());
      }

      public List<? extends class_1297> find(Spell spell, String selector) {
        try {
          boolean atAllowed = true;
          class_2303 reader =
              new class_2303(new StringReader(selector), atAllowed);
          class_2300 entitySelector = reader.method_9882();
          class_2168 commandSource = spell.createCommandSource();
          return entitySelector.method_9816(commandSource);
        } catch (CommandSyntaxException e) {
          throw new LuaRuntimeException(e);
        }
      }
    }

    private class FindSpellsFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "findSpells";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        Table criteria = getConverters().toJavaOptional(Table.class, arg2, 2, "criteria", getName())
            .orElse(new DefaultTable());
        Spell spell = self.getDelegate();
        Iterable<Spell> result = find(spell, criteria);
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }

      private Iterable<Spell> find(Spell spell, Table criteria) {
        List<Predicate<Spell>> predicates = new ArrayList<>();
        String name =
            getConverters().toJavaNullable(String.class, criteria.rawget("name"), "criteria.name");
        if (name != null) {
          predicates.add((Spell it) -> name.equals(it.getName()));
        }
        String owner = getConverters().toJavaNullable(String.class, criteria.rawget("owner"),
            "criteria.owner");
        if (owner != null) {
          predicates.add((Spell it) -> it.getOwner() != null
              && owner.equals(spell.getOwner().method_5477().getString()));
        }
        String tag =
            getConverters().toJavaNullable(String.class, criteria.rawget("tag"), "criteria.tag");
        if (tag != null) {
          predicates.add((Spell it) -> it.getTags().contains(tag));
        }
        Number sid =
            getConverters().toJavaNullable(Number.class, criteria.rawget("sid"), "criteria.sid");
        if (sid != null) {
          predicates.add((Spell it) -> it.getSid() == sid.longValue());
        }
        Number maxradius = getConverters().toJavaNullable(Number.class,
            criteria.rawget("maxradius"), "criteria.maxradius");
        if (maxradius != null) {
          double rmaxSq = maxradius.doubleValue() * maxradius.doubleValue();
          predicates.add((Spell it) -> it.getDistanceSq(spell) <= rmaxSq);
        }
        Number minradius = getConverters().toJavaNullable(Number.class,
            criteria.rawget("minradius"), "criteria.minradius");
        if (minradius != null) {
          double rminSq = minradius.doubleValue() * minradius.doubleValue();
          predicates.add((Spell it) -> it.getDistanceSq(spell) >= rminSq);
        }
        boolean excludeSelf = getConverters()
            .toJavaOptional(Boolean.class, criteria.rawget("excludeSelf"), "criteria.excludeSelf")
            .orElse(false);
        if (excludeSelf) {
          predicates.add((Spell it) -> it != spell);
        }
        return spell.findSpells(predicates);
      }
    }

    class CollectFunction extends NamedFunctionAnyArg {
      @Override
      public String getName() {
        return "collect";
      }

      @Override
      public void invoke(ExecutionContext context, Object[] args) throws ResolvedControlThrowable {
        Deque<Object> argList = new ArrayDeque<Object>(Arrays.asList(args));
        Object arg1 = argList.isEmpty() ? null : argList.pop();
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        List<String> eventNames =
            getConverters().toJavaList(String.class, argList.toArray(), getName());

        Spell spell = self.getDelegate();
        EventQueue eventQueue = spell.createEventQueue(eventNames);
        Object result = getConverters().toLua(eventQueue);
        context.getReturnBuffer().setTo(result);
      }

      @Override
      public void resume(ExecutionContext context, Object suspendedState)
          throws ResolvedControlThrowable {
        throw new NonsuspendableFunctionException(this.getClass());
      }
    }

    class InterceptFunction extends NamedFunction4 {
      @Override
      public String getName() {
        return "intercept";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3,
          Object arg4) throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        Spell spell = self.getDelegate();
        List<String> eventNames =
            getConverters().toJavaList(String.class, arg2, 2, "eventNames", getName());
        LuaFunction eventHandler =
            getConverters().toJava(LuaFunction.class, arg3, 3, "eventHandler", getName());
        Long luaTicksLimit =
            getConverters().toJavaNullable(long.class, arg4, 4, "luaTicksLimit", getName());
        EventInterceptor eventInterceptor =
            spell.createEventInterceptor(eventNames, eventHandler, luaTicksLimit);
        Object result = getConverters().toLua(eventInterceptor);
        context.getReturnBuffer().setTo(result);
      }
    }

    class RaycastBlockFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "raycastBlock";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        Spell spell = self.getDelegate();
        class_3965 result = RaycastUtil.raycastToBlock(spell, maxDistance);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class RaycastEntityFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "raycastEntity";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        boolean excludeSpellOwner = getConverters()
            .toJavaOptional(boolean.class, arg3, 3, "excludeSpellOwner", getName()).orElse(false);
        Spell spell = self.getDelegate();
        class_3966 result = RaycastUtil.raycastToEntity(spell, maxDistance, excludeSpellOwner);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class RaycastFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "raycast";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        boolean excludeSpellOwner = getConverters()
            .toJavaOptional(boolean.class, arg3, 3, "excludeSpellOwner", getName()).orElse(false);
        Spell spell = self.getDelegate();
        class_239 result = RaycastUtil.raycast(spell, maxDistance, excludeSpellOwner);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class FireFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "fire";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String name = getConverters().toJava(String.class, arg2, 2, "name", getName());
        Table data = getConverters().toJavaNullable(Table.class, arg3, 3, "data", getName());
        Spell spell = self.getDelegate();
        boolean proceed = spell.fireEvent(new CustomEvent(name, data));
        context.getReturnBuffer().setTo(getConverters().toLua(proceed));
      }
    }

    class KillFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "kill";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        Spell spell = self.getDelegate();
        spell.setDead();
        context.getReturnBuffer().setTo();
      }
    }

    class MoveFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "move";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().toJava(LuaSpell.class, arg1, 1, "self", getName());
        String direction = getConverters().toJava(String.class, arg2, 2, "direction", getName());
        double distance =
            getConverters().toJavaOptional(Double.class, arg3, 3, "distance", getName()).orElse(1d);
        WolDirection dir = WolDirection.byName(direction);
        Spell spell = self.getDelegate();
        spell.move(dir, distance);
        context.getReturnBuffer().setTo();
      }
    }

    class EvaluateFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "evaluate";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        boolean hasPlaceholderApi = FabricLoader.getInstance().isModLoaded("placeholder-api");
        if (!hasPlaceholderApi) {
          throw new UnsupportedOperationException(
              "Placeholder API not found. Please drop placeholder-api-*.jar into mods folder.");
        }
        LuaSpell<?, ?> self = getConverters().castTo(LuaSpell.class, arg1, 1, "self", getName());
        class_2168 commandSource = self.getLuaClass().getCommandSource();
        String text = getConverters().toJava(String.class, arg2, 2, "text", getName());
        PlaceholderContext ctx = PlaceholderContext.of(commandSource);
        class_2561 parsed = Placeholders.parseText(class_2561.method_43470(text), ctx);
        String value = parsed.getString(); // unformatted text
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(value));
      }
    }

    class CopyStructureFunction extends NamedFunction4 {
      @Override
      public String getName() {
        return "copyStructure";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object oppositeCornerArg,
          Object includeEntitiesArg, Object ignoreArg) throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().castTo(LuaSpell.class, selfArg, 1, "self", getName());
        class_2382 opposite = toVec3i(
            getConverters().toJava(class_243.class, oppositeCornerArg, 2, "oppositeCorner", getName()));
        class_2338 pos = self.getDelegate().getBlockPos();

        int minX = Math.min(pos.method_10263(), opposite.method_10263());
        int minY = Math.min(pos.method_10264(), opposite.method_10264());
        int minZ = Math.min(pos.method_10260(), opposite.method_10260());

        int maxX = Math.max(pos.method_10263(), opposite.method_10263());
        int maxY = Math.max(pos.method_10264(), opposite.method_10264());
        int maxZ = Math.max(pos.method_10260(), opposite.method_10260());

        class_2338 min = new class_2338(minX, minY, minZ);

        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;

        class_2338 start = min;
        class_2382 dimensions = new class_2382(sizeX, sizeY, sizeZ);

        boolean includeEntities = getConverters()
            .toJavaOptional(boolean.class, includeEntitiesArg, 3, "includeEntities", getName())
            .orElse(false);
        String ignore =
            getConverters().toJavaNullable(String.class, ignoreArg, 4, "ignoreBlockId", getName());

        class_3499 template = new class_3499();
        class_1297 owner = self.getDelegate().getOwner();
        if (owner instanceof class_1309 author) {
          template.method_15161(author.method_5477().getString());
        }

        class_2248 ignoredBlock = ignore == null ? null : class_7923.field_41175.method_63535(class_2960.method_60654(ignore));
        List<class_2248> ignoredBlocks =
            ignoredBlock == null ? Collections.emptyList() : List.of(ignoredBlock);
        template.method_15174(getWorld(), start, dimensions, includeEntities, ignoredBlocks);
        context.getReturnBuffer().setTo(getConverters().toLua(template));
      }
    }

    class PasteStructureFunction extends NamedFunction4 {
      @Override
      public String getName() {
        return "pasteStructure";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object templateArg,
          Object originOffsetArg, Object ignoreBlockIdsArg) throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().castTo(LuaSpell.class, selfArg, 1, "self", getName());
        class_3499 template =
            getConverters().toJava(class_3499.class, templateArg, 2, "template", getName());
        class_243 originOffset = getConverters()
            .toJavaOptional(class_243.class, originOffsetArg, 3, "originOffset", getName())
            .orElse(class_243.field_1353);

        List<String> ignore = getConverters().toJavaListNullable(String.class, ignoreBlockIdsArg, 3,
            "ignoreBlockIds", getName());

        class_3218 world = self.getDelegate().getWorld();

        class_2338 spellPos = class_2338.method_49638(self.getDelegate().getPos());
        class_2338 originLocal = class_2338.method_49638(originOffset);
        class_2338 originGlobal = spellPos.method_10059(originLocal);
        class_3492 placementData = new class_3492();
        placementData.method_15119(originLocal); // is used as pivot
        placementData.method_15123(toBlockRotation(self.getDelegate().getYaw()));

        if (ignore != null) {
          List<class_2248> blockIds =
              ignore.stream().map(it -> class_7923.field_41175.method_63535(class_2960.method_60654(it))).toList();
          placementData.method_16184(new class_3793(blockIds));
        }
        class_2338 pivot = originGlobal; // not sure.
        template.method_15172(world, originGlobal, pivot, placementData, class_5819.method_43049(0),
            class_2248.field_31036);
        context.getReturnBuffer().setTo();
      }

      private class_2470 toBlockRotation(float f) {
        int steps = (int) Math.round(f / 90.0);
        int index = Math.floorMod(steps, 4);
        return switch (index) {
          case 0 -> class_2470.field_11467;
          case 1 -> class_2470.field_11463;
          case 2 -> class_2470.field_11464;
          case 3 -> class_2470.field_11465;
          default -> throw new IllegalStateException("unreachable: " + index);
        };
      }
    }

    class SetYawFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "setYaw";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object directionArg)
          throws ResolvedControlThrowable {
        LuaSpell<?, ?> self = getConverters().castTo(LuaSpell.class, selfArg, 1, "self", getName());
        String direction =
            getConverters().toJava(String.class, directionArg, 2, "direction", getName());
        class_2350 dir = class_2350.method_10168(direction);
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
          return;
        }
        float yaw = dir.method_10144();
        self.getDelegate().setYaw(yaw);
        context.getReturnBuffer().setTo();
      }
    }

    private class_2382 toVec3i(class_243 v) {
      int x = (int) Math.floor(v.field_1352);
      int y = (int) Math.floor(v.field_1351);
      int z = (int) Math.floor(v.field_1350);
      return new class_2382(x, y, z);
    }
  }

  //////

  public LuaSpell(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("world", this::getWorld);
    addReadOnly("id", this::getId);
    add("name", this::getName, this::setName);
    addReadOnly("owner", this::getOwner);
    addReadOnly("age", this::getAge);
    add("pos", this::getPos, this::setPos);
    addReadOnly("lookVec", this::getLookVec);
    add("pitch", this::getPitch, this::setPitch);
    add("yaw", this::getYaw, this::setYaw);
    add("velocity", this::getVelocity, this::setVelocity);
    add("block", this::getBlock, this::setBlock);
    addReadOnly("blockEntity", this::getBlockEntity);
    add("forceChunk", this::isForceChunk, this::setForceChunk);
    add("visible", this::isVisible, this::setVisible);
    addReadOnly("server", this::getServer);
    addReadOnly("facing", this::getFacing);
    add("tickLimit", this::getTickLimit, this::setTickLimit);
    addReadOnly("biome", this::getBiome);
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().getWorld());
  }

  private Object getId() {
    return getConverters().toLua(getDelegate().getSid());
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getName());
  }

  private void setName(Object luaObject) {
    String name = getConverters().toJava(String.class, luaObject, "name");
    getDelegate().setName(name);
  }

  private Object getOwner() {
    return getConverters().toLuaNullable(getDelegate().getOwner());
  }

  private Object getAge() {
    return getConverters().toLua(getDelegate().getAge());
  }

  private Object getPos() {
    return getConverters().toLua(getDelegate().getPos());
  }

  private void setPos(Object luaObject) {
    class_243 pos = getConverters().toJava(class_243.class, luaObject, "pos");
    getDelegate().setPos(pos);
  }

  private Object getLookVec() {
    return getConverters().toLua(getDelegate().getLookVector());
  }

  private Object getPitch() {
    return getConverters().toLua(getDelegate().getPitch());
  }

  private void setPitch(Object luaObject) {
    float pitch = getConverters().toJava(float.class, luaObject, "pitch");
    getDelegate().setPitch(pitch);
  }

  private Object getYaw() {
    return getConverters().toLua(getDelegate().getYaw());
  }

  private void setYaw(Object luaObject) {
    float yaw = getConverters().toJava(float.class, luaObject, "yaw");
    getDelegate().setYaw(yaw);
  }

  private Object getVelocity() {
    return getConverters().toLua(getDelegate().getVelocity());
  }

  private void setVelocity(Object luaObject) {
    class_243 velocity = getConverters().toJava(class_243.class, luaObject, "velocity");
    getDelegate().setVelocity(velocity);
  }

  private Object getBlock() {
    return getConverters().toLua(getDelegate().getBlockState());
  }

  private void setBlock(Object luaObject) {
    class_2680 blockState = getConverters().toJava(class_2680.class, luaObject, "blockState");
    getDelegate().setBlockState(blockState);
  }

  private Object getBlockEntity() {
    return getConverters().toLuaNullable(getDelegate().getBlockEntity());
  }

  private Object isForceChunk() {
    return getConverters().toLua(getDelegate().isForceChunk());
  }

  private void setForceChunk(Object luaObject) {
    getDelegate().setForceChunk(getConverters().toJava(boolean.class, luaObject, "forceChunk"));
  }

  private Object isVisible() {
    return getConverters().toLua(getDelegate().isVisible());
  }

  private void setVisible(Object luaObject) {
    getDelegate().setVisible(getConverters().toJava(boolean.class, luaObject, "visible"));
  }

  private Object getServer() {
    return getConverters().toLua(getDelegate().getWorld().method_8503());
  }

  private Object getFacing() {
    return getConverters().toLua(class_2350.method_10150(getDelegate().getYaw()));
  }

  private Object getTickLimit() {
    return getConverters().toLua(getDelegate().getProgram().getLuaTicksLimit());
  }

  private void setTickLimit(Object luaObject) {
    long tickLimit = getConverters().toJava(Long.class, luaObject, "tickLimit");
    getDelegate().getProgram().setLuaTicksLimit(tickLimit);
  }

  private Object getBiome() {
    class_1937 world = getDelegate().getWorld();
    class_6880<class_1959> biome = world.method_23753(getDelegate().getBlockPos());
    String result = biome.method_40230().get().method_29177().method_43903();
    return getConverters().toLua(result);
  }
}
