package net.wizardsoflua.lua.classes;

import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.module.types.TypesModule;
import net.wizardsoflua.lua.table.DelegatingLuaTable;

public class TypesModuleLuaTable extends DelegatingLuaTable<TypesModule> {
  public TypesModuleLuaTable(TypesModule delegate, LuaConverters converters) {
    super(delegate, converters, false);
    addFunction(new DeclareFunction());
    addFunction(new InstanceOfFunction());
    addFunction(new TypeFunction());
  }

  private class DeclareFunction extends NamedFunction2 {
    @Override
    public String getName() {
      return "declare";
    }

    @Override
    public void invoke(ExecutionContext context, Object arg1, Object arg2)
        throws ResolvedControlThrowable {
      String className = getConverters().toJava(String.class, arg1, 1, "className", getName());
      Table metatable =
          getConverters().toJavaNullable(Table.class, arg2, 2, "metatable", getName());
      Table result = getDelegate().declare(className, metatable);
      context.getReturnBuffer().setTo(result);
    }
  }

  private class InstanceOfFunction extends NamedFunction2 {
    @Override
    public String getName() {
      return "instanceOf";
    }

    @Override
    public void invoke(ExecutionContext context, Object arg1, Object arg2)
        throws ResolvedControlThrowable {
      Table classTable = getConverters().toJava(Table.class, arg1, 1, "classTable", getName());
      Object object = arg2;
      boolean result = getDelegate().instanceOf(classTable, object);
      context.getReturnBuffer().setTo(result);
    }
  }

  private class TypeFunction extends NamedFunction1 {
    @Override
    public String getName() {
      return "type";
    }

    @Override
    public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
      Object LuaObject = arg1;
      String result = getDelegate().type(LuaObject);
      Object luaResult = getConverters().toLuaNullable(result);
      context.getReturnBuffer().setTo(luaResult);
    }
  }
}
