package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.sandius.rembulan.Table;

/**
 * Merges {@link class_2499}s by matching the elements via their list index.
 *
 * @author Adrodoc55
 */
public class IndexBasedNbtListMergeStrategy implements NbtListMergeStrategy {
  private final NbtConverter converter;

  public IndexBasedNbtListMergeStrategy(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2499 merge(class_2499 nbt, Table data, String path) {
    class_2499 result = nbt.method_10612();
    for (int i = 0; i < nbt.size(); ++i) {
      class_2520 oldNbtValue = nbt.get(i);
      Object newLuaValue = data.rawget(i + 1);
      if (newLuaValue != null) {
        String key = String.valueOf(i);
        class_2520 newNbtValue =
            converter.merge(oldNbtValue, newLuaValue, key, path + "[" + i + "]");
        result.method_68585(i, newNbtValue);
      }
    }
    return result;
  }
}
