package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2487;
import net.sandius.rembulan.Table;

public class NbtCompoundMerger implements NbtMerger<class_2487> {
  private final NbtConverter converter;

  public NbtCompoundMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2487 merge(class_2487 nbt, Object data, String key, String path) {
    if (data instanceof Table) {
      return converter.merge(nbt, (Table) data, path);
    }
    throw converter.conversionException(path, data, "table");
  }
}
