package net.wizardsoflua.spell;

import static java.util.Objects.requireNonNull;
import java.util.LinkedHashMap;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryCache;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.world.WorldChunkTracker;

public class SpellFactory {
  private final SpellRegistry spellRegistry;
  private final WolDirectories directories;
  private final WolModule wolModule;
  private final WorldChunkTracker worldChunkTracker;
  private final LuaFunctionBinaryCache luaFunctionCache = new LuaFunctionBinaryCache();
  private final ChunkForceManager chunkForceManager = new ChunkForceManager();
  private long nextSid = 1;

  public SpellFactory(SpellRegistry spellRegistry, WolDirectories directories, WolModule wolModule,
      WorldChunkTracker worldChunkTracker) {
    this.spellRegistry = requireNonNull(spellRegistry, "spellRegistry");
    this.directories = requireNonNull(directories, "directories");
    this.wolModule = requireNonNull(wolModule, "wolModule");
    this.worldChunkTracker = requireNonNull(worldChunkTracker, "worldChunkTracker");
  }

  public Spell createSpell(class_2168 commandSource, String code,
      LinkedHashMap<Object, Object> argsMap) {
    SpellScope spellScope = new SpellScope(spellRegistry, chunkForceManager, directories, wolModule,
        worldChunkTracker, commandSource);
    SpellProgram program = new SpellProgram(luaFunctionCache, spellScope, code, argsMap);
    nextSid++;
    class_243 pos = commandSource.method_9222();
    Spell spell = new Spell(nextSid, spellScope, pos, program);
    spellRegistry.add(spell);
    spell.tick();
    return spell;
  }
}
