package net.wizardsoflua.spell;

import static java.util.Objects.requireNonNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import net.wizardsoflua.util.WolDirection;

public class VirtualEntity {
  private final SpellScope spellScope;
  private class_243 pos;
  private final VirtualEntityChunkForceSupport chunkForceSupport;
  private final long startedTime;
  private boolean alive;
  private String name;
  private final Set<String> tags = new HashSet<>(); // TODO expose in LuaSpell.
  private float pitch;
  private float yaw;
  private class_243 velocity = class_243.field_1353;

  public VirtualEntity(SpellScope spellScope, class_243 pos) {
    this.spellScope = requireNonNull(spellScope, "spellScope");
    this.pos = pos;
    chunkForceSupport = new VirtualEntityChunkForceSupport(spellScope.getChunkForceManager(), this);
    this.startedTime = spellScope.getWorld().method_8510();
    alive = true;
    setForceChunk(true);
  }

  public void setForceChunk(boolean value) {
    if (value) {
      chunkForceSupport.requestNewTicket();
    } else {
      chunkForceSupport.releaseTicket();
    }
  }

  public boolean isForceChunk() {
    return chunkForceSupport.hasTicket();
  }

  public class_3218 getWorld() {
    return spellScope.getWorld();
  }

  public long getStartedTime() {
    return startedTime;
  }

  public long getAge() {
    return getWorld().method_8510() - getStartedTime();
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public boolean isAlive() {
    return alive;
  }

  public void setDead() {
    alive = false;
    chunkForceSupport.releaseTicket();
  }

  public class_2561 getDisplayName() {
    return class_2561.method_30163(getName());
  }

  public Set<String> getTags() {
    return tags;
  }

  public void setTags(Collection<String> tags) {
    tags.clear();
    tags.addAll(tags);
  }

  public boolean addTag(String tag) {
    return tags.add(tag);
  }

  public boolean removeTag(String tag) {
    return tags.remove(tag);
  }

  public class_243 getPos() {
    return pos;
  }

  public void setPos(class_243 pos) {
    this.pos = requireNonNull(pos, "pos");
    chunkForceSupport.updatePosition();
  }

  public void move(WolDirection dir, double distance) {
    class_243 offset = dir.getDirectionVec(yaw).method_1021(distance);
    class_243 newPos = getPos().method_1019(offset);
    setPos(newPos);
  }

  public class_2338 getBlockPos() {
    return class_2338.method_49638(getPos());
  }

  public double getDistanceSq(VirtualEntity entity) {
    return getPos().method_1025(entity.getPos());
  }

  public float getPitch() {
    return pitch;
  }

  public void setPitch(float pitch) {
    this.pitch = pitch;
  }

  public float getYaw() {
    return yaw;
  }

  public void setYaw(float yaw) {
    this.yaw = yaw;
  }

  public class_243 getLookVector() {
    return getRotationVector(pitch, yaw);
  }

  public class_241 getRotationClient() {
    return new class_241(this.getPitch(), this.getYaw());
  }

  public class_243 getVelocity() {
    return this.velocity;
  }

  public void setVelocity(class_243 velocity) {
    this.velocity = velocity;
  }

  /**
   * {@link class_1297#method_5631(float, float)}
   */
  private final class_243 getRotationVector(float pitch, float yaw) {
    float f = pitch * (float) (Math.PI / 180.0);
    float g = -yaw * (float) (Math.PI / 180.0);
    float h = class_3532.method_15362(g);
    float i = class_3532.method_15374(g);
    float j = class_3532.method_15362(f);
    float k = class_3532.method_15374(f);
    return new class_243(i * j, (-k), h * j);
  }

  public class_2168 createCommandSource() {
    class_2165 output = new class_2165() {
      @Override
      public boolean method_9202() {
        return true;
      }

      @Override
      public boolean method_9200() {
        return true;
      }

      @Override
      public boolean method_9201() {
        return true;
      }

      @Override
      public void method_43496(class_2561 text) {
        // ignore
      }
    };
    return createCommandSource(output);
  }

  public SpellServerCommandSource createCommandSource(class_2165 output) {
    class_243 pos = getPos();
    class_241 rot = getRotationClient();
    int level = 4; // Permission Level Operator
    String name = getName();
    class_2561 displayName = getDisplayName();
    class_1297 entity = null;
    MinecraftServer server = getWorld().method_8503();
    class_3218 world = getWorld();
    return new SpellServerCommandSource(output, pos, rot, world, level, name, displayName, server,
        entity);
  }

  public void tick() {
    class_243 newPOs = pos.method_1019(velocity);
    setPos(newPOs);
  }
}
