package net.wizardsoflua.world;

import static java.util.Objects.requireNonNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;

public class WorldChunkTracker {
  private final Map<class_5321<class_1937>, LongOpenHashSet> byDim = new ConcurrentHashMap<>();

  public void add(class_1937 world, class_1923 pos) {
    requireNonNull(world, "world");
    requireNonNull(pos, "pos");
    var key = world.method_27983();
    byDim.computeIfAbsent(key, k -> new LongOpenHashSet()).add(pos.method_8324());
  }

  public void remove(class_1937 world, class_1923 pos) {
    requireNonNull(world, "world");
    requireNonNull(pos, "pos");
    var key = world.method_27983();
    var set = byDim.get(key);
    if (set != null) {
      set.remove(pos.method_8324());
      if (set.isEmpty())
        byDim.remove(key);
    }
  }

  public void remove(class_3218 world) {
    var key = world.method_27983();
    byDim.remove(key);
  }

  public void clear() {
    byDim.clear();
  }

  public boolean isLoaded(class_1937 world, class_1923 cp) {
    requireNonNull(world, "world");
    requireNonNull(cp, "cp");
    var set = byDim.get(world.method_27983());
    if (set == null || !set.contains(cp.method_8324())) {
      return false;
    }

    // Paranoid guard: verify there is a FULL WorldChunk without loading it.
    if (world instanceof class_3218 sw) {
      var chunk = sw.method_8402(cp.field_9181, cp.field_9180, net.minecraft.class_2806.field_12803, false);
      if (!(chunk instanceof net.minecraft.class_2818)) {
        // Our tracker was wrong. Fix it and report false.
        set.remove(cp.method_8324());
        if (set.isEmpty())
          byDim.remove(sw.method_27983());
        return false;
      }
    }
    return true;
  }
}
