/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.command.LuaCommand;
import net.wizardsoflua.command.WolExtractApiCommand;
import net.wizardsoflua.command.WolExtractExamplesCommand;
import net.wizardsoflua.command.WolSpellBreakCommand;
import net.wizardsoflua.command.WolSpellListCommand;
import net.wizardsoflua.command.WolStartupCommand;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;
import net.wizardsoflua.event.SpellTerminatedCallback;
import net.wizardsoflua.event.WolEventHandler;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.spell.SpellCaster;
import net.wizardsoflua.spell.SpellFactory;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.startup.Startup;
import net.wizardsoflua.world.WorldChunkTracker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardsOfLuaMod
implements ModInitializer {
    public static final String MOD_ID = "wizardsoflua";
    public static final int WOL_PERMISSION_LEVEL = 2;
    public static WizardsOfLuaMod INSTANCE;
    public static Logger LOGGER;
    private WolDirectories directories;
    private WolModule wolModule;
    private SpellRegistry spellRegistry;
    private WorldChunkTracker worldChunkTracker;
    private SpellFactory spellFactory;
    private SpellCaster spellCaster;
    private WolEventHandler eventHandler;
    private DynamicCommandManager dynamicCommandManager;
    private Startup startup;
    private AttachmentType<class_2487> extraEntityAttachmentType;

    public void onInitialize() {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        INSTANCE = this;
        this.directories = new WolDirectories();
        this.wolModule = new WolModule(this::getVersion, this::getDynamicCommandManager);
        this.spellRegistry = new SpellRegistry();
        this.worldChunkTracker = new WorldChunkTracker();
        this.spellFactory = new SpellFactory(this.spellRegistry, this.directories, this.wolModule, this.worldChunkTracker);
        this.spellCaster = new SpellCaster(this.spellFactory);
        this.eventHandler = new WolEventHandler(this.spellRegistry, this.worldChunkTracker);
        this.dynamicCommandManager = new DynamicCommandManager(this.spellCaster);
        this.startup = new Startup(this.directories, this.spellRegistry, this.spellCaster, this.dynamicCommandManager);
        this.extraEntityAttachmentType = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"wol", (String)"extra"), builder -> builder.persistent(class_2487.field_25128).initializer(class_2487::new).copyOnDeath());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            new LuaCommand(this.spellCaster).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new WolSpellListCommand(this.spellRegistry).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new WolSpellBreakCommand(this.spellRegistry).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new WolStartupCommand(this.startup).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new WolExtractApiCommand(this.directories).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new WolExtractExamplesCommand(this.directories).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            this.dynamicCommandManager.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.startup.run(server.method_3739()));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.spellRegistry.breakSpells(this.spellRegistry.getAll()));
        ServerTickEvents.START_SERVER_TICK.register(server -> this.spellRegistry.tick());
        ServerTickEvents.START_SERVER_TICK.register(server -> this.dynamicCommandManager.tick(server));
        SpellTerminatedCallback.EVENT.register(this.spellRegistry::onSpellTermiated);
        this.eventHandler.register();
    }

    public AttachmentType<class_2487> getExtraEntityAttachmentType() {
        return this.extraEntityAttachmentType;
    }

    public Path getLuaSrcDir() {
        return this.directories.getLuaSrcDir();
    }

    @Nullable
    public String getVersion() {
        return FabricLoader.getInstance().getModContainer(MOD_ID).map(it -> {
            Version version = it.getMetadata().getVersion();
            return version.getFriendlyString();
        }).orElse("");
    }

    private DynamicCommandManager getDynamicCommandManager() {
        return this.dynamicCommandManager;
    }
}

