/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class LuaInstanceCache {
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().weakKeys().softValues().build();

    public <L, J> L getOrCreate(J javaInstance, Function<J, L> toLuaMapper) {
        ConcurrentMap map = this.cache.asMap();
        return (L)map.computeIfAbsent(javaInstance, toLuaMapper::apply);
    }

    public <J> boolean replaceKey(J oldKey, J newKey) {
        Object value = this.cache.getIfPresent(oldKey);
        if (value != null) {
            this.cache.invalidate(oldKey);
            this.cache.put(newKey, value);
            return true;
        }
        return false;
    }
}

