/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.compiler;

import java.util.Objects;
import net.sandius.rembulan.Variable;
import net.sandius.rembulan.compiler.CompiledModule;
import net.sandius.rembulan.compiler.CompilerSettings;
import net.sandius.rembulan.compiler.LuaCompiler;
import net.sandius.rembulan.load.ChunkClassLoader;
import net.sandius.rembulan.load.ChunkLoader;
import net.sandius.rembulan.load.CompiledChunk;
import net.sandius.rembulan.load.LoaderException;
import net.sandius.rembulan.parser.ParseException;
import net.sandius.rembulan.parser.TokenMgrError;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.lua.compiler.ExtendedChunkLoader;
import net.wizardsoflua.lua.compiler.LuaFunctionBinary;

public class PatchedCompilerChunkLoader
implements ChunkLoader,
ExtendedChunkLoader {
    private final ChunkClassLoader chunkClassLoader;
    private final String rootClassPrefix;
    private final LuaCompiler compiler;
    private int idx;

    PatchedCompilerChunkLoader(ClassLoader classLoader, LuaCompiler compiler, String rootClassPrefix) {
        this.chunkClassLoader = new ChunkClassLoader(Objects.requireNonNull(classLoader));
        this.compiler = Objects.requireNonNull(compiler);
        this.rootClassPrefix = Objects.requireNonNull(rootClassPrefix);
        this.idx = 0;
    }

    public static PatchedCompilerChunkLoader of(ClassLoader classLoader, LuaCompiler compiler, String rootClassPrefix) {
        return new PatchedCompilerChunkLoader(classLoader, compiler, rootClassPrefix);
    }

    public static PatchedCompilerChunkLoader of(ClassLoader classLoader, CompilerSettings compilerSettings, String rootClassPrefix) {
        return new PatchedCompilerChunkLoader(classLoader, new LuaCompiler(compilerSettings), rootClassPrefix);
    }

    public static PatchedCompilerChunkLoader of(ClassLoader classLoader, String rootClassPrefix) {
        return PatchedCompilerChunkLoader.of(classLoader, CompilerSettings.defaultSettings(), rootClassPrefix);
    }

    public static PatchedCompilerChunkLoader of(LuaCompiler compiler, String rootClassPrefix) {
        return PatchedCompilerChunkLoader.of(PatchedCompilerChunkLoader.class.getClassLoader(), compiler, rootClassPrefix);
    }

    public static PatchedCompilerChunkLoader of(CompilerSettings compilerSettings, String rootClassPrefix) {
        return PatchedCompilerChunkLoader.of(new LuaCompiler(compilerSettings), rootClassPrefix);
    }

    public static PatchedCompilerChunkLoader of(String rootClassPrefix) {
        return PatchedCompilerChunkLoader.of(CompilerSettings.defaultSettings(), rootClassPrefix);
    }

    public ChunkClassLoader getChunkClassLoader() {
        return this.chunkClassLoader;
    }

    @Override
    public LuaFunctionBinary compile(String chunkName, String sourceText) throws LoaderException {
        Objects.requireNonNull(chunkName);
        Objects.requireNonNull(sourceText);
        PatchedCompilerChunkLoader patchedCompilerChunkLoader = this;
        synchronized (patchedCompilerChunkLoader) {
            String rootClassName = this.rootClassPrefix + this.idx++;
            try {
                CompiledModule result = this.compiler.compile(sourceText, chunkName, rootClassName);
                String mainClassName = this.chunkClassLoader.install((CompiledChunk)result);
                Class clazz = this.chunkClassLoader.loadClass(mainClassName);
                return new LuaFunctionBinary(clazz, chunkName);
            }
            catch (TokenMgrError ex) {
                String msg = ex.getMessage();
                int line = 0;
                boolean partial = msg != null && msg.contains("Encountered: <EOF>");
                throw new LoaderException((Throwable)ex, chunkName, line, partial);
            }
            catch (ParseException ex) {
                boolean partial = ex.currentToken != null && ex.currentToken.next != null && ex.currentToken.next.kind == 0;
                int line = ex.currentToken != null ? ex.currentToken.beginLine : 0;
                throw new LoaderException((Throwable)ex, chunkName, line, partial);
            }
            catch (LinkageError | ReflectiveOperationException | RuntimeException ex) {
                throw new LoaderException(ex, chunkName, 0, false);
            }
        }
    }

    public LuaFunction loadTextChunk(Variable env, String chunkName, String sourceText) throws LoaderException {
        Objects.requireNonNull(env);
        Objects.requireNonNull(chunkName);
        Objects.requireNonNull(sourceText);
        PatchedCompilerChunkLoader patchedCompilerChunkLoader = this;
        synchronized (patchedCompilerChunkLoader) {
            String rootClassName = this.rootClassPrefix + this.idx++;
            try {
                CompiledModule result = this.compiler.compile(sourceText, chunkName, rootClassName);
                String mainClassName = this.chunkClassLoader.install((CompiledChunk)result);
                Class clazz = this.chunkClassLoader.loadClass(mainClassName);
                return (LuaFunction)clazz.getConstructor(Variable.class).newInstance(env);
            }
            catch (TokenMgrError ex) {
                String msg = ex.getMessage();
                int line = 0;
                boolean partial = msg != null && msg.contains("Encountered: <EOF>");
                throw new LoaderException((Throwable)ex, chunkName, line, partial);
            }
            catch (ParseException ex) {
                boolean partial = ex.currentToken != null && ex.currentToken.next != null && ex.currentToken.next.kind == 0;
                int line = ex.currentToken != null ? ex.currentToken.beginLine : 0;
                throw new LoaderException((Throwable)ex, chunkName, line, partial);
            }
            catch (LinkageError | ReflectiveOperationException | RuntimeException ex) {
                throw new LoaderException(ex, chunkName, 0, false);
            }
        }
    }
}

