/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.wizardsoflua.command.CommandRegisterer;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;

public class WolSpellListCommand
implements CommandRegisterer {
    private static final String WOL_PERMISSION = "wizardsoflua.wol";
    private static final String WOL_SPELL_PERMISSION = "wizardsoflua.wol.spell";
    private static final String WOL_SPELL_LIST_PERMISSION = "wizardsoflua.wol.spell.list";
    private static final String SID_ARG = "sid";
    private static final String NAME_ARG = "name";
    private static final String OWNER_ARG = "owner";
    private static final int MAX_LINE_LENGTH = 100;
    private static final String ELLIPSIS = "...";
    private final SpellRegistry spellRegistry;

    public WolSpellListCommand(SpellRegistry spellRegistry) {
        this.spellRegistry = Objects.requireNonNull(spellRegistry, "spellRegistry");
    }

    @Override
    public void register(CommandDispatcher<class_2168> d, class_7157 registryAccess, class_2170.class_5364 environment) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wol").requires(src -> src.method_9228() == null || Permissions.check((class_2172)src, (String)WOL_SPELL_PERMISSION, (int)2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spell").requires(src -> src.method_9228() == null || Permissions.check((class_2172)src, (String)WOL_SPELL_PERMISSION, (int)2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> src.method_9228() == null || Permissions.check((class_2172)src, (String)WOL_SPELL_LIST_PERMISSION, (int)2))).executes(this::listByCaller)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.list.all", (int)2))).executes(this::listAll))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bySid").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.list.bySid", (int)2))).then(class_2170.method_9244((String)SID_ARG, (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::listBySid)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byName").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.list.byName", (int)2))).then(class_2170.method_9244((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(this::listByName)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byOwner").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.list.byOwner", (int)2))).then(class_2170.method_9244((String)OWNER_ARG, (ArgumentType)class_2186.method_9305()).executes(this::listByOwner))))));
    }

    private int listByCaller(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_1297 entity = source.method_9228();
        String msg = "Your active spells";
        return this.listSpells(source, msg, (Spell s) -> entity.equals((Object)s.getOwner()));
    }

    private int listAll(CommandContext<class_2168> ctx) {
        String msg = "Active spells";
        return this.listSpells((class_2168)ctx.getSource(), msg, this.spellRegistry.getAll());
    }

    private int listBySid(CommandContext<class_2168> ctx) {
        int sid = IntegerArgumentType.getInteger(ctx, (String)SID_ARG);
        String msg = "Active spells with sid " + sid;
        return this.listSpells((class_2168)ctx.getSource(), msg, (Spell s) -> s.getSid() == (long)sid);
    }

    private int listByName(CommandContext<class_2168> ctx) {
        String name = StringArgumentType.getString(ctx, (String)NAME_ARG);
        String msg = "Active spells with name '" + name + "'";
        return this.listSpells((class_2168)ctx.getSource(), msg, (Spell s) -> name.equals(s.getName()));
    }

    private int listByOwner(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 owner = class_2186.method_9315(ctx, (String)OWNER_ARG);
        String msg = "Active spells of " + owner.method_5477().getString();
        return this.listSpells((class_2168)ctx.getSource(), msg, (Spell s) -> owner.equals((Object)s.getOwner()));
    }

    private int listSpells(class_2168 src, String msg, Predicate<Spell> filter) {
        return this.listSpells(src, msg, this.spellRegistry.get(filter));
    }

    private int listSpells(class_2168 src, String message, Collection<Spell> spells) {
        int count = spells.size();
        if (count == 0) {
            src.method_9226(() -> class_2561.method_30163((String)"No spells found"), false);
        } else {
            class_5250 formatted = this.format(message, spells);
            src.method_9226(() -> formatted, false);
        }
        return count;
    }

    private class_5250 format(String message, Iterable<Spell> spells) {
        class_5250 result = class_2561.method_43470((String)(message + ":\n")).method_27661().method_27692(class_124.field_1065);
        for (Spell spell : spells) {
            class_5250 line = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("#" + spell.getSid())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(spell.getDisplayName()).method_10852((class_2561)class_2561.method_43470((String)": "));
            Object code = spell.getProgram().getCode();
            int max = 100 - line.getString().length();
            if (((String)code).length() > max) {
                code = max < ELLIPSIS.length() ? ELLIPSIS : ((String)code).substring(0, max - ELLIPSIS.length()) + ELLIPSIS;
            }
            line.method_10852((class_2561)class_2561.method_43470((String)code).method_27692(class_124.field_1075));
            result.method_10852((class_2561)line).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        return result;
    }
}

