/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.scheduling;

import com.google.common.base.Preconditions;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.lua.scheduling.LuaSchedulingContext;
import net.wizardsoflua.lua.scheduling.LuaSchedulingContextFactory;

public class PausableSchedulingContextFactory
implements LuaSchedulingContextFactory {
    private long luaTickLimit;
    private final Context context;

    public PausableSchedulingContextFactory(long luaTickLimit, Context context) {
        this.luaTickLimit = luaTickLimit;
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context == null!");
    }

    @Override
    public LuaSchedulingContext newInstance() {
        return new LuaSchedulingContext(this.luaTickLimit, this.context){

            @Override
            public void registerTicks(int ticks) {
                super.registerTicks(ticks);
                PausableSchedulingContextFactory.this.context.registerTicks(ticks);
            }

            @Override
            public boolean shouldPause() {
                return super.shouldPause() || PausableSchedulingContextFactory.this.context.shouldPause();
            }

            @Override
            public boolean isAutosleep() {
                return PausableSchedulingContextFactory.this.context.isAutosleep();
            }

            @Override
            public void setAutosleep(boolean autosleep) {
                PausableSchedulingContextFactory.this.context.setAutosleep(autosleep);
            }

            @Override
            public void pause(ExecutionContext context) throws UnresolvedControlThrowable {
                context.pause();
            }

            @Override
            public void pauseIfRequested(ExecutionContext context) throws UnresolvedControlThrowable {
                context.pauseIfRequested();
            }
        };
    }

    public static interface Context
    extends LuaSchedulingContext.Context {
        public boolean shouldPause();

        public boolean isAutosleep();

        public void setAutosleep(boolean var1);
    }
}

