/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.table;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.TableFactory;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.config.ConversionException;
import net.wizardsoflua.lua.BadArgumentException;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.table.TableIterable;
import net.wizardsoflua.lua.table.TableIterator;
import org.jetbrains.annotations.Nullable;

public class TableUtils {
    private static final Pattern LUA_IDENTIFIER = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private static final Converters CONVERSION = new Converters(TableUtils::getTypes);
    private static final Types TYPES = new Types(TableUtils::getConversion);

    private static Converters getConversion() {
        return CONVERSION;
    }

    private static Types getTypes() {
        return TYPES;
    }

    private TableUtils() {
    }

    public static Table copy(Table original, TableFactory tableFactory) {
        Table result = tableFactory.newTable();
        TableIterator it = new TableIterator(original);
        while (it.hasNext()) {
            Object entry = it.next();
            result.rawset(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> Optional<T> getAsOptional(Class<T> type, Table table, String key) {
        return Optional.ofNullable(TableUtils.getAsNullable(type, table, key));
    }

    @Nullable
    public static <T> T getAsNullable(Class<T> type, Table table, String key) {
        Object value = table.rawget((Object)key);
        if (value == null) {
            return null;
        }
        return TableUtils.getAs(type, table, key);
    }

    public static <T> T getAs(Class<T> type, Table table, String key) {
        Object value = table.rawget((Object)key);
        try {
            return CONVERSION.toJava(type, value, key);
        }
        catch (BadArgumentException ex) {
            throw new ConversionException(String.format("Can't convert value '%s'! %s expected, but got: %s", key, type.getName(), value.getClass().getName()), ex);
        }
    }

    public static String asString(Table table) {
        StringWriter writer = new StringWriter();
        TableUtils.writeTo(new PrintWriter(writer), table);
        return writer.toString();
    }

    public static void writeTo(PrintWriter out, Table table) {
        TableUtils.writeTo(out, table, "");
    }

    public static void writeTo(PrintWriter out, Table table, String indent) {
        String lineIndent = indent + "  ";
        out.write("{ ");
        TableIterable it = new TableIterable(table);
        String delimitter = "\n";
        for (Map.Entry<Object, Object> entry : it) {
            out.write(delimitter);
            out.write(lineIndent);
            Object key = entry.getKey();
            out.write(TableUtils.toOutKey(key));
            out.write("=");
            Object value = entry.getValue();
            if (value instanceof Table) {
                TableUtils.writeTo(out, (Table)value, lineIndent);
            } else {
                out.write(TableUtils.toOutValue(key, value));
            }
            delimitter = ",\n";
        }
        out.write("\n");
        out.write(indent);
        out.write("}");
    }

    private static String toOutKey(Object key) {
        if (key instanceof Long) {
            String result = ((Long)key).toString();
            return result;
        }
        if (key instanceof ByteString || key instanceof String) {
            String result = String.valueOf(key);
            if (!TableUtils.isLuaIdentifier(result)) {
                return "[\"" + result + "\"]";
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("table contains an invalid key '%s'!", key));
    }

    @Nullable
    private static String toOutValue(Object key, @Nullable Object value) {
        if (value instanceof Boolean) {
            String result = ((Boolean)value).toString();
            return result;
        }
        if (value instanceof Number) {
            String result = ((Number)value).toString();
            return result;
        }
        if (value instanceof ByteString || value instanceof String) {
            String result = "\"" + TableUtils.escapeQuotes(String.valueOf(value)) + "\"";
            return result;
        }
        if (value instanceof LuaFunction) {
            LuaFunction f = (LuaFunction)value;
            return f.toString();
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException(String.format("table contains an invalid value '%s' of type %s for key '%s'!", value, value.getClass(), key));
    }

    private static String escapeQuotes(String str) {
        return str.replace("\"", "\\\"");
    }

    private static boolean isLuaIdentifier(String text) {
        return LUA_IDENTIFIER.matcher(text).matches();
    }
}

