/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.startup;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;
import net.wizardsoflua.spell.SpellCaster;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.startup.StartupModuleFinder;

public class Startup {
    private final WolDirectories directories;
    private final SpellRegistry spellRegistry;
    private final SpellCaster spellCaster;
    private final DynamicCommandManager dynamicCommandManager;
    private final StartupModuleFinder startupModuleFinder = new StartupModuleFinder();

    public Startup(WolDirectories directories, SpellRegistry spellRegistry, SpellCaster spellCaster, DynamicCommandManager dynamicCommandManager) {
        this.directories = Objects.requireNonNull(directories, "directories");
        this.spellRegistry = Objects.requireNonNull(spellRegistry, "spellRegistry");
        this.spellCaster = Objects.requireNonNull(spellCaster, "spellCaster");
        this.dynamicCommandManager = Objects.requireNonNull(dynamicCommandManager, "dynamicCommandManager");
    }

    public int run(class_2168 source) {
        this.dynamicCommandManager.clearAll(source);
        this.spellRegistry.breakSpells(this.spellRegistry.getAll());
        int result = 0;
        try {
            Path dir = this.directories.getLuaSrcDir();
            List<String> startupModules = this.startupModuleFinder.findStartupModulesIn(dir);
            for (String module : startupModules) {
                result += this.spellCaster.castNewSpell(source, "require(\"" + module + "\")");
            }
        }
        catch (IOException e) {
            this.handleException(e, source);
        }
        return result;
    }

    private void handleException(Throwable t, class_2168 source) {
        String message = String.format("An unexpected error occured during startup sequence: %s", t.getMessage());
        WizardsOfLuaMod.LOGGER.error(message, t);
        String stackTrace = this.getStackTrace(t);
        class_5250 errorText = class_5250.method_43477((class_7417)class_8828.method_54232((String)message)).method_27693(stackTrace);
        source.method_9213((class_2561)errorText);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        Object result = writer.toString();
        if (((String)result).length() > 200) {
            result = ((String)result).substring(0, 200) + "...";
        }
        return result;
    }
}

