/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.wizardsoflua.command.CommandRegisterer;
import net.wizardsoflua.command.dynamic.DynamicCommandParser;
import net.wizardsoflua.command.dynamic.ParseResult;
import net.wizardsoflua.command.dynamic.Placeholder;
import net.wizardsoflua.command.dynamic.Token;
import net.wizardsoflua.spell.SpellCaster;

public class DynamicCommandManager
implements CommandRegisterer {
    private static final SimpleCommandExceptionType NO_PERMISSION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You do not have permission to use this command"));
    private final SpellCaster spellCaster;
    private final Map<String, CommandDef> dynamicCommandsDefs = new LinkedHashMap<String, CommandDef>();
    private final Multimap<String, String> reachableCommands = LinkedListMultimap.create();
    private boolean needsReload = false;
    private boolean needsSync = false;

    public DynamicCommandManager(SpellCaster spellCaster) {
        this.spellCaster = Objects.requireNonNull(spellCaster, "spellCaster");
    }

    public Map<String, CommandDef> getAll() {
        return Collections.unmodifiableMap(this.dynamicCommandsDefs);
    }

    public void set(String commandId, String pattern, String code, class_2168 src, int level) {
        ParseResult parseResult = DynamicCommandParser.parse(pattern);
        CommandDef commandDef = new CommandDef(pattern, code, level, parseResult);
        CommandDef oldCommandDef = this.dynamicCommandsDefs.put(commandId, commandDef);
        if (oldCommandDef != null) {
            Map map = this.reachableCommands.asMap();
            Collection<String> nodeIds = oldCommandDef.parseResult().getNodeIds();
            for (String nodeId : nodeIds) {
                Collection col = (Collection)map.get(nodeId);
                col.remove(commandId);
            }
        }
        for (String nodeId : parseResult.getNodeIds()) {
            this.reachableCommands.put((Object)nodeId, (Object)commandId);
        }
        this.markForReload();
    }

    public boolean remove(String commandId, class_2168 src) {
        CommandDef commandDef = this.dynamicCommandsDefs.remove(commandId);
        if (commandDef == null) {
            return false;
        }
        for (String nodeId : commandDef.parseResult().getNodeIds()) {
            this.reachableCommands.remove((Object)nodeId, (Object)commandId);
        }
        this.markForReload();
        return true;
    }

    public void clearAll(class_2168 src) {
        if (this.dynamicCommandsDefs.isEmpty()) {
            return;
        }
        this.dynamicCommandsDefs.clear();
        this.reachableCommands.clear();
        this.markForReload();
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        for (Map.Entry<String, CommandDef> entry : this.dynamicCommandsDefs.entrySet()) {
            dispatcher.register(this.buildLiteral(entry.getKey(), entry.getValue(), registryAccess));
            this.needsSync = true;
        }
    }

    public void tick(MinecraftServer server) {
        if (this.needsSync) {
            this.needsSync = false;
            this.sendCommandTree(server);
        }
        if (this.needsReload) {
            this.needsReload = false;
            this.reload(server);
        }
    }

    private void reload(MinecraftServer server) {
        server.method_3734().method_44252(server.method_3739(), "/reload");
    }

    private void sendCommandTree(MinecraftServer server) {
        class_2170 mgr = server.method_3734();
        for (class_3222 player : server.method_3760().method_14571()) {
            mgr.method_9241(player);
        }
    }

    private void markForReload() {
        this.needsReload = true;
    }

    private LiteralArgumentBuilder<class_2168> buildLiteral(String commandId, CommandDef def, class_7157 registryAccess) {
        ArgumentBuilder chain;
        List<Token> tokens = def.parseResult.tokens();
        int lastPlaceholderIdx = def.parseResult.findLastPlaceholderIndex();
        ArrayList<Object> builders = new ArrayList<Object>();
        ArrayList<Function<CommandContext, Object>> extractors = new ArrayList<Function<CommandContext, Object>>();
        ArrayList<Object> luaArgNames = new ArrayList<Object>();
        int autoCount = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            boolean greedy;
            Token tok = tokens.get(i);
            if (!tok.isPlaceholder()) {
                builders.add(class_2170.method_9247((String)tok.raw()));
                continue;
            }
            String argName = tok.isNamed() ? tok.name() : String.valueOf(++autoCount) + ":" + tok.placeholder().getName();
            Placeholder ph = tok.placeholder();
            boolean bl = greedy = ph == Placeholder.STRING && i == lastPlaceholderIdx;
            if (ph == Placeholder.STRING && tok.enumValues() != null) {
                List<String> opts = tok.enumValues();
                RequiredArgumentBuilder argB = class_2170.method_9244((String)argName, (ArgumentType)(greedy ? StringArgumentType.greedyString() : StringArgumentType.string())).suggests((ctx, sb) -> {
                    for (String v : opts) {
                        sb.suggest(v);
                    }
                    return sb.buildFuture();
                });
                builders.add(argB);
                extractors.add(ctx -> {
                    String val = StringArgumentType.getString((CommandContext)ctx, (String)argName);
                    if (!opts.contains(val)) {
                        throw new IllegalArgumentException("Unknown value \"" + val + "\"");
                    }
                    return val;
                });
            } else {
                builders.add(ph.createBuilder(argName, greedy, registryAccess));
                extractors.add(ctx -> ph.extract((CommandContext<class_2168>)ctx, argName, registryAccess));
            }
            luaArgNames.add(tok.isNamed() ? tok.name() : Integer.valueOf(autoCount));
        }
        int size = builders.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String nodeId = def.parseResult.getNodeId(i);
                builders.set(i, ((ArgumentBuilder)builders.get(i)).requires(src -> {
                    Collection commandIds = this.reachableCommands.get((Object)nodeId);
                    return src.method_9228() == null || commandIds.stream().map(cId -> Permissions.check((class_2172)src, (String)cId, (int)def.level())).anyMatch(b -> b);
                }));
            }
        }
        Command exec = ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            LinkedHashMap<Object, Object> args = new LinkedHashMap<Object, Object>();
            try {
                for (int j = 0; j < extractors.size(); ++j) {
                    Object v = ((Function)extractors.get(j)).apply(ctx);
                    if (v == null) continue;
                    args.put(luaArgNames.get(j), v);
                }
            }
            catch (IllegalArgumentException e) {
                class_2561 message = class_2561.method_30163((String)e.getMessage());
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
            }
            return this.spellCaster.castNewSpell(src, def.code(), args);
        };
        if (builders.isEmpty()) {
            chain = ((LiteralArgumentBuilder)class_2170.method_9247((String)"").requires(src -> src.method_9228() == null || Permissions.check((class_2172)src, (String)commandId, (int)def.level()))).executes(exec);
        } else {
            int i = builders.size() - 1;
            chain = ((ArgumentBuilder)builders.get(i)).executes(ctx -> {
                String cmdId = commandId;
                class_2168 src = (class_2168)ctx.getSource();
                if (src.method_9228() != null && !Permissions.check((class_2172)src, (String)commandId, (int)def.level())) {
                    throw NO_PERMISSION.create();
                }
                return exec.run(ctx);
            });
            for (int j = builders.size() - 2; j >= 0; --j) {
                chain = ((ArgumentBuilder)builders.get(j)).then(chain);
            }
        }
        return (LiteralArgumentBuilder)chain;
    }

    public record CommandDef(String pattern, String code, int level, ParseResult parseResult) {
    }
}

