/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wizardsoflua.command.dynamic.ParseResult;
import net.wizardsoflua.command.dynamic.Placeholder;
import net.wizardsoflua.command.dynamic.Token;
import org.jetbrains.annotations.Nullable;

public class DynamicCommandParser {
    private static final Pattern ENUM_PATTERN = Pattern.compile("^([a-zA-Z]+)\\[(.+)]$");

    @Nullable
    public static ParseResult parse(String pattern) {
        if (pattern == null || pattern.isBlank()) {
            return null;
        }
        String[] parts = pattern.trim().split("\\s+");
        ArrayList<Token> tokens = new ArrayList<Token>(parts.length);
        int totalPlaceholders = 0;
        int namedPlaceholders = 0;
        for (String part : parts) {
            if (part.startsWith("%")) {
                String rawCode = part.substring(1);
                List<String> enumValues = null;
                String code = rawCode;
                String node = rawCode;
                Matcher m = ENUM_PATTERN.matcher(rawCode);
                if (m.matches()) {
                    code = m.group(1);
                    enumValues = List.of(m.group(2).split("\\|"));
                }
                Placeholder ph = Placeholder.byCode(code);
                tokens.add(new Token(part, true, null, node, ph, enumValues));
                ++totalPlaceholders;
                continue;
            }
            if (part.contains(":%")) {
                int idx = part.indexOf(":%");
                String name = part.substring(0, idx);
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Placeholder missing name before ':%' in '" + part + "'");
                }
                String node = name;
                String rawCode = part.substring(idx + 2);
                List<String> enumValues = null;
                String code = rawCode;
                Matcher m = ENUM_PATTERN.matcher(rawCode);
                if (m.matches()) {
                    code = m.group(1);
                    enumValues = List.of(m.group(2).split("\\|"));
                }
                Placeholder ph = Placeholder.byCode(code);
                tokens.add(new Token(part, true, name, node, ph, enumValues));
                ++totalPlaceholders;
                ++namedPlaceholders;
                continue;
            }
            String nodeName = part;
            tokens.add(new Token(part, false, null, nodeName, null, null));
        }
        if (namedPlaceholders > 0 && namedPlaceholders < totalPlaceholders) {
            throw new IllegalArgumentException("Invalid command pattern. Either name all placeholders or none of them.");
        }
        return new ParseResult(tokens);
    }
}

