/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.extract;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.wizardsoflua.WizardsOfLuaMod;

public class LuaExamplesExtractor {
    public int run(class_2168 source, Path outputDir) throws CommandSyntaxException {
        try {
            if (this.extractFiles(source, outputDir)) {
                return 1;
            }
        }
        catch (IOException | URISyntaxException e) {
            this.handleException(e, source);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractFiles(class_2168 source, Path outputDir) throws IOException, URISyntaxException {
        this.deleteFilesInDirectory(outputDir);
        Path sourcePath = Paths.get(Objects.requireNonNull(LuaExamplesExtractor.class.getProtectionDomain().getCodeSource().getLocation()).toURI());
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            Path devLuaDir = this.findProjectRoot().resolve("src/examples");
            if (Files.exists(devLuaDir, new LinkOption[0])) {
                this.copyDirectory(devLuaDir, outputDir);
                source.method_9226(() -> class_2561.method_30163((String)("Example files copied from source dir: " + String.valueOf(devLuaDir.toAbsolutePath()) + " to: " + String.valueOf(outputDir.toAbsolutePath()))), false);
                return true;
            }
            class_2561 errorText = class_2561.method_30163((String)("Example source directory not found: " + String.valueOf(devLuaDir.toAbsolutePath()) + " to: " + String.valueOf(outputDir.toAbsolutePath())));
            source.method_9213(errorText);
            return false;
        }
        try (ZipFile jar = new ZipFile(sourcePath.toFile());){
            boolean bl;
            ZipEntry zipEntry = jar.getEntry("examples.zip");
            if (zipEntry == null) {
                class_2561 errorText = class_2561.method_30163((String)("examples.zip not found in JAR file: " + String.valueOf(sourcePath.toAbsolutePath())));
                source.method_9213(errorText);
                boolean bl2 = false;
                return bl2;
            }
            Path tempZipFile = Files.createTempFile("examples", ".zip", new FileAttribute[0]);
            try {
                try (InputStream zipStream = jar.getInputStream(zipEntry);
                     OutputStream tempOut = Files.newOutputStream(tempZipFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    zipStream.transferTo(tempOut);
                }
                try (ZipFile zipFile = new ZipFile(tempZipFile.toFile());){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory()) continue;
                        Path destFile = outputDir.resolve(entry.getName());
                        Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                        InputStream in = zipFile.getInputStream(entry);
                        try {
                            OutputStream out = Files.newOutputStream(destFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            try {
                                in.transferTo(out);
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                }
                source.method_9226(() -> class_2561.method_30163((String)("Example files extracted from JAR to: " + String.valueOf(outputDir.toAbsolutePath()))), false);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    Files.deleteIfExists(tempZipFile);
                }
                catch (IOException e) {
                    WizardsOfLuaMod.LOGGER.warn("Failed to delete temporary file: " + String.valueOf(tempZipFile), (Throwable)e);
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(tempZipFile);
            }
            catch (IOException e) {
                WizardsOfLuaMod.LOGGER.warn("Failed to delete temporary file: " + String.valueOf(tempZipFile), (Throwable)e);
            }
            return bl;
        }
    }

    private void deleteFilesInDirectory(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(this::deleteFile);
    }

    private void deleteFile(Path p) {
        try {
            Files.delete(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path findProjectRoot() {
        Path current;
        for (current = Paths.get("", new String[0]).toAbsolutePath(); current != null && !Files.exists(current.resolve("src/examples"), new LinkOption[0]); current = current.getParent()) {
        }
        return current != null ? current : Paths.get("", new String[0]);
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(path -> {
            try {
                Path dest = target.resolve(source.relativize((Path)path));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                } else {
                    Files.copy(path, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy: " + String.valueOf(path), e);
            }
        });
    }

    private void handleException(Throwable t, class_2168 source) {
        String message = String.format("An unexpected error occured during the extraction of api files: %s", t.getMessage());
        WizardsOfLuaMod.LOGGER.error(message, t);
        String stackTrace = this.getStackTrace(t);
        class_5250 errorText = class_5250.method_43477((class_7417)class_8828.method_54232((String)message)).method_27693(stackTrace);
        source.method_9213((class_2561)errorText);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        Object result = writer.toString();
        if (((String)result).length() > 200) {
            result = ((String)result).substring(0, 200) + "...";
        }
        return result;
    }
}

