/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.lua.BadArgumentException;
import net.wizardsoflua.lua.RaycastUtil;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.mixin.interfaces.ExtendedEntity;
import net.wizardsoflua.spell.SpellScope;

public class LuaEntity<J extends class_1297, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaEntity(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
        this.addReadOnly("world", this::getWorld);
        this.add("name", this::getName, this::setName);
        this.addReadOnly("uuid", this::getUuid);
        this.addReadOnly("type", this::getType);
        this.addReadOnly("age", this::getAge);
        this.add("nbt", this::getNbt, this::setNbt);
        this.add("pos", this::getPos, this::setPos);
        this.addReadOnly("eyePos", this::getEyePos);
        this.addReadOnly("lookVec", this::getLookVec);
        this.add("pitch", this::getPitch, this::setPitch);
        this.add("yaw", this::getYaw, this::setYaw);
        this.add("velocity", this::getVelocity, this::setVelocity);
        this.add("invisible", this::isInvisible, this::setInvisible);
        this.addReadOnly("alive", this::isAlive);
        this.add("sprinting", this::isSprinting, this::setSprinting);
        this.addReadOnly("crawling", this::isCrawling);
        this.add("sneaking", this::isSneaking, this::setSneaking);
        this.add("extra", this::getExtra, this::setExtra);
        this.addReadOnly("facing", this::getFacing);
    }

    private Object getExtra() {
        ExtendedEntity entity = (ExtendedEntity)this.getDelegate();
        class_2487 extra = entity.getExtra();
        return NbtConverter.toLua(extra);
    }

    private void setExtra(Object luaObject) {
        ExtendedEntity entity = (ExtendedEntity)this.getDelegate();
        Table data = this.getConverters().toJava(Table.class, luaObject, "table");
        class_2487 extra = ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter().merge(new class_2487(), data);
        entity.setExtra(extra);
    }

    private void putExtra(Table part) {
        ExtendedEntity entity = (ExtendedEntity)this.getDelegate();
        class_2487 extra = entity.getExtra();
        class_2487 newExtra = ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter().merge(extra, part);
        entity.setExtra(newExtra);
    }

    private Object getWorld() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_73183());
    }

    protected Object getName() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5477());
    }

    protected void setName(Object luaObject) {
        Optional<String> name = this.getConverters().toJavaOptional(String.class, luaObject, "name");
        ((class_1297)this.getDelegate()).method_5665((class_2561)name.map(class_2561::method_30163).orElse(null));
    }

    protected Object getUuid() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5845());
    }

    private Object getType() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5864());
    }

    private Object getAge() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).field_6012);
    }

    private Object getNbt() {
        try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER);){
            class_5455 registries = ((class_1297)this.getDelegate()).method_56673();
            class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            ((class_1297)this.getDelegate()).method_5647((class_11372)writeView);
            class_2487 result = writeView.method_71475();
            Table table = NbtConverter.toLua(result);
            return table;
        }
    }

    private void putNbt(Table nbt) {
        LuaEntity.putNbt((class_1297)this.getDelegate(), ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter(), nbt);
    }

    public static void putNbt(class_1297 itemEntity, NbtConverter nbtConverter, Table nbt) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER);){
            class_5455 registries = itemEntity.method_56673();
            class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            itemEntity.method_5647((class_11372)writeView);
            class_2487 oldNbt = writeView.method_71475();
            class_2487 newNbt = nbtConverter.merge(oldNbt, nbt);
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registries, (class_2487)newNbt);
            itemEntity.method_5651(view);
        }
    }

    private void setNbt(Object luaObject) {
        Table data = this.getConverters().toJava(Table.class, luaObject, "nbt");
        class_2487 newNbt = ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter().merge(new class_2487(), data);
        try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER);){
            class_5455 registries = ((class_1297)this.getDelegate()).method_56673();
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registries, (class_2487)newNbt);
            ((class_1297)this.getDelegate()).method_5651(view);
        }
    }

    private Object getPos() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_73189());
    }

    private void setPos(Object luaObject) {
        class_243 pos = this.getConverters().toJava(class_243.class, luaObject, "pos");
        this.setPosVec3d(this.checkPos(pos));
    }

    private class_243 checkPos(class_243 pos) {
        if (!class_1937.method_25953((class_2338)class_2338.method_49637((double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350))) {
            throw new BadArgumentException("Not a valid world position", 1, "pos");
        }
        return pos;
    }

    protected void setPosVec3d(class_243 pos) {
        ((class_1297)this.getDelegate()).method_33574(pos);
    }

    private Object getEyePos() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_33571());
    }

    private Object getLookVec() {
        class_243 result = RaycastUtil.getLookVector((class_1297)this.getDelegate(), 1.0);
        return this.getConverters().toLua(result);
    }

    private Object getPitch() {
        return this.getConverters().toLua(Float.valueOf(((class_1297)this.getDelegate()).method_36455()));
    }

    private void setPitch(Object luaObject) {
        float pitch = this.getConverters().toJava(Float.TYPE, luaObject, "pitch").floatValue();
        ((class_1297)this.getDelegate()).method_36457(pitch);
    }

    private Object getYaw() {
        return this.getConverters().toLua(Float.valueOf(((class_1297)this.getDelegate()).method_36454()));
    }

    private void setYaw(Object luaObject) {
        float yaw = this.getConverters().toJava(Float.TYPE, luaObject, "yaw").floatValue();
        ((class_1297)this.getDelegate()).method_36456(yaw);
    }

    private Object getVelocity() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_18798());
    }

    private void setVelocity(Object luaObject) {
        class_243 velocity = this.getConverters().toJava(class_243.class, luaObject, "velocity");
        ((class_1297)this.getDelegate()).method_18799(velocity);
        ((class_1297)this.getDelegate()).field_6037 = true;
    }

    private Object isInvisible() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5767());
    }

    private void setInvisible(Object luaObject) {
        ((class_1297)this.getDelegate()).method_5648(this.getConverters().toJava(Boolean.TYPE, luaObject, "invisible").booleanValue());
    }

    private Object isAlive() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5805());
    }

    private Object isSprinting() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5624());
    }

    private void setSprinting(Object luaObject) {
        ((class_1297)this.getDelegate()).method_5728(this.getConverters().toJava(Boolean.TYPE, luaObject, "sprinting").booleanValue());
    }

    private Object isCrawling() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_20448());
    }

    private Object isSneaking() {
        return this.getConverters().toLua(((class_1297)this.getDelegate()).method_5715());
    }

    private void setSneaking(Object luaObject) {
        ((class_1297)this.getDelegate()).method_5660(this.getConverters().toJava(Boolean.TYPE, luaObject, "sneeking").booleanValue());
    }

    private Object getFacing() {
        return this.getConverters().toLua(class_2350.method_10150((double)((class_1297)this.getDelegate()).method_36454()));
    }

    public static class Class
    extends AbstractLuaClass<class_1297, LuaEntity<class_1297, Class>> {
        public Class(SpellScope spellScope) {
            super("Entity", spellScope, null);
            this.addFunction(new PutNbtFunction());
            this.addFunction(new KillFunction());
            this.addFunction(new RaycastBlockFunction());
            this.addFunction(new RaycastEntityFunction());
            this.addFunction(new RaycastFunction());
            this.addFunction(new DropItemFunction());
            this.addFunction(new EvaluateFunction());
            this.addFunction(new PutExtraFunction());
        }

        @Override
        protected final LuaEntity<class_1297, Class> createNewLuaInstance(class_1297 javaInstance) {
            return new LuaEntity<class_1297, Class>(this, javaInstance);
        }

        class PutNbtFunction
        extends NamedFunction2 {
            PutNbtFunction() {
            }

            @Override
            public String getName() {
                return "putNbt";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                Table nbt = Class.this.getConverters().toJava(Table.class, arg2, 2, "nbt", this.getName());
                self.putNbt(nbt);
                context.getReturnBuffer().setTo();
            }
        }

        class KillFunction
        extends NamedFunction1 {
            KillFunction() {
            }

            @Override
            public String getName() {
                return "kill";
            }

            public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                class_3218 world = (class_3218)((class_1297)self.getDelegate()).method_73183();
                ((class_1297)self.getDelegate()).method_5768(world);
                context.getReturnBuffer().setTo();
            }
        }

        class RaycastBlockFunction
        extends NamedFunction2 {
            RaycastBlockFunction() {
            }

            @Override
            public String getName() {
                return "raycastBlock";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                class_1297 entity = (class_1297)self.getDelegate();
                class_3965 result = RaycastUtil.raycastFromEyeToBlock(entity, maxDistance);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class RaycastEntityFunction
        extends NamedFunction2 {
            RaycastEntityFunction() {
            }

            @Override
            public String getName() {
                return "raycastEntity";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                class_1297 entity = (class_1297)self.getDelegate();
                class_3966 result = RaycastUtil.raycastFromEyeToEntity(entity, maxDistance);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class RaycastFunction
        extends NamedFunction2 {
            RaycastFunction() {
            }

            @Override
            public String getName() {
                return "raycast";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                class_1297 entity = (class_1297)self.getDelegate();
                class_239 result = RaycastUtil.raycastFromEye(entity, maxDistance);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class DropItemFunction
        extends NamedFunction3 {
            DropItemFunction() {
            }

            @Override
            public String getName() {
                return "dropItem";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                String typeName = Class.this.getTypes().getLuaTypeNameOfLuaObject(arg2);
                float yOffset = Class.this.getConverters().toJavaOptional(Float.TYPE, arg3, 3, "yOffset", this.getName()).orElse(Float.valueOf(0.0f)).floatValue();
                class_1799 itemStack = switch (typeName) {
                    case "Item" -> Class.this.getConverters().toJava(class_1799.class, arg2, "item");
                    case "BlockType" -> new class_1799((class_1935)Class.this.getConverters().toJava(class_2248.class, arg2, "blockType"));
                    case "ItemType" -> new class_1799((class_1935)Class.this.getConverters().toJava(class_1792.class, arg2, "itemType"));
                    default -> throw new BadArgumentException("Expected argument of type Item, BlockType, orItemType");
                };
                class_3218 world = (class_3218)((class_1297)self.getDelegate()).method_73183();
                class_1542 itemEntity = ((class_1297)self.getDelegate()).method_5699(world, itemStack.method_7972(), yOffset);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(itemEntity));
            }
        }

        class EvaluateFunction
        extends NamedFunction2 {
            EvaluateFunction() {
            }

            @Override
            public String getName() {
                return "evaluate";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                boolean hasPlaceholderApi = FabricLoader.getInstance().isModLoaded("placeholder-api");
                if (!hasPlaceholderApi) {
                    throw new UnsupportedOperationException("Placeholder API not found. Please drop placeholder-api-*.jar into mods folder.");
                }
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                String text = Class.this.getConverters().toJava(String.class, arg2, 2, "text", this.getName());
                PlaceholderContext ctx = PlaceholderContext.of((class_1297)((class_1297)self.getDelegate()));
                class_2561 parsed = Placeholders.parseText((class_2561)class_2561.method_43470((String)text), (PlaceholderContext)ctx);
                String value = parsed.getString();
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(value));
            }
        }

        class PutExtraFunction
        extends NamedFunction2 {
            PutExtraFunction() {
            }

            @Override
            public String getName() {
                return "putExtra";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaEntity self = Class.this.getConverters().toJava(LuaEntity.class, arg1, 1, "self", this.getName());
                Table nbt = Class.this.getConverters().toJava(Table.class, arg2, 2, "nbt", this.getName());
                self.putExtra(nbt);
                context.getReturnBuffer().setTo();
            }
        }
    }
}

