/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.print;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.lib.BasicLib;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.lua.module.print.OutputReceiver;
import net.wizardsoflua.lua.module.print.TabEncoder;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class PrintRedirector {
    private final OutputReceiver outputReceiver;

    public static PrintRedirector installInto(Table env, OutputReceiver outputReceiver) {
        return new PrintRedirector(env, outputReceiver);
    }

    public PrintRedirector(Table env, OutputReceiver outputReceiver) {
        this.outputReceiver = outputReceiver;
        ChatOutputStream out = new ChatOutputStream();
        LuaFunction printFunc = BasicLib.print((OutputStream)((Object)out), (Object)env);
        env.rawset((Object)"print", (Object)printFunc);
    }

    private void print(String message) {
        this.outputReceiver.send(TabEncoder.encode(message));
    }

    private class ChatOutputStream
    extends ByteArrayOutputStream {
        private ChatOutputStream() {
        }

        public void flush() throws IOException {
            String message = this.toString(Charset.defaultCharset());
            if ((message = message.replaceAll("\r", "")).endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            this.reset();
            PrintRedirector.this.print(message);
        }
    }
}

