/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.searcher;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.nio.charset.Charset;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.Variable;
import net.sandius.rembulan.impl.NonsuspendableFunctionException;
import net.sandius.rembulan.runtime.AbstractFunction1;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.compiler.ExtendedChunkLoader;
import net.wizardsoflua.lua.compiler.LuaFunctionBinary;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryByUrlCache;
import org.apache.commons.io.IOUtils;

public class ClasspathResourceSearcher {
    public static void installInto(Table env, ExtendedChunkLoader loader, LuaFunctionBinaryByUrlCache cache, ClassLoader classloader) {
        Object function = ClasspathResourceSearcher.getFunction(env, loader, cache, classloader);
        Table pkg = (Table)env.rawget((Object)"package");
        Table searchers = (Table)pkg.rawget((Object)"searchers");
        long len = searchers.rawlen();
        searchers.rawset(len + 1L, function);
    }

    private static Object getFunction(Table env, ExtendedChunkLoader loader, LuaFunctionBinaryByUrlCache cache, ClassLoader classloader) {
        return new LoaderFunction(env, loader, cache, classloader);
    }

    private static class LoaderFunction
    extends AbstractFunction1 {
        private final Table env;
        private ExtendedChunkLoader loader;
        private LuaFunctionBinaryByUrlCache cache;
        private ClassLoader classloader;

        public LoaderFunction(Table env, ExtendedChunkLoader loader, LuaFunctionBinaryByUrlCache cache, ClassLoader classloader) {
            this.env = env;
            this.loader = loader;
            this.cache = cache;
            this.classloader = classloader;
        }

        public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
            String moduleName = String.valueOf(arg1);
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Expected module name, but got: %s", moduleName));
            }
            try {
                if (moduleName.endsWith(".lua")) {
                    throw new IllegalArgumentException("Illegal module '" + moduleName + "': module must be specified without '.lua' extension!");
                }
                String name = moduleName.replaceAll("\\.", "/") + ".lua";
                URL resource = this.classloader.getResource(name);
                if (resource == null) {
                    context.getReturnBuffer().setTo((Object)("no module with name '" + name + "' found in classpath"));
                    return;
                }
                LuaFunctionBinary fnBin = this.cache.get(resource);
                if (fnBin == null) {
                    String src = IOUtils.toString((URL)resource, (Charset)Charset.defaultCharset());
                    fnBin = this.loader.compile(moduleName, src);
                    this.cache.put(resource, fnBin);
                }
                LuaFunction fn = fnBin.loadInto(new Variable((Object)this.env));
                context.getReturnBuffer().setTo((Object)fn, (Object)moduleName);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            throw new NonsuspendableFunctionException();
        }
    }
}

