/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.nbt;

import com.google.common.base.Preconditions;
import net.minecraft.class_2479;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.nbt.NbtMerger;

public class NbtByteArrayMerger
implements NbtMerger<class_2479> {
    private final NbtConverter converter;

    public NbtByteArrayMerger(NbtConverter converter) {
        this.converter = (NbtConverter)Preconditions.checkNotNull((Object)converter, (Object)"converter == null!");
    }

    @Override
    public class_2479 merge(class_2479 nbt, Object data, String key, String path) {
        Table table;
        if (data instanceof Table && NbtConverter.isArray(table = (Table)data)) {
            long len = table.rawlen();
            if (len > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Can't merge arrays with more that Integer.MAX_VALUE elements!");
            }
            byte[] arr = new byte[(int)len];
            for (int i = 0; i < arr.length; ++i) {
                byte newNbtValue;
                Object newLuaValue = table.rawget((long)(i + 1));
                if (newLuaValue == null) continue;
                arr[i] = newNbtValue = Conversions.integerValueOf((Object)newLuaValue).byteValue();
            }
            class_2479 result = new class_2479(arr);
            return result;
        }
        throw this.converter.conversionException(path, data, "table");
    }
}

