/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.nbt;

import com.google.common.base.Preconditions;
import net.minecraft.class_2499;
import net.sandius.rembulan.Table;
import net.wizardsoflua.lua.nbt.IndexBasedNbtListMergeStrategy;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.nbt.NbtMerger;
import net.wizardsoflua.lua.nbt.ValueBasedNbtListMergeStrategy;

public class NbtListMerger
implements NbtMerger<class_2499> {
    private final NbtConverter converter;

    public NbtListMerger(NbtConverter converter) {
        this.converter = (NbtConverter)Preconditions.checkNotNull((Object)converter, (Object)"converter == null!");
    }

    @Override
    public class_2499 merge(class_2499 nbt, Object data, String key, String path) {
        if (data instanceof Table) {
            Table table = (Table)data;
            switch (key) {
                case "ActiveEffects": {
                    return new ValueBasedNbtListMergeStrategy("Id", this.converter).merge(nbt, table, path);
                }
                case "EnderItems": 
                case "Inventory": 
                case "Items": {
                    return new ValueBasedNbtListMergeStrategy("Slot", this.converter).merge(nbt, table, path);
                }
                case "AttributeModifiers": 
                case "Tags": {
                    return this.converter.toNbtList(table, path);
                }
            }
            return new IndexBasedNbtListMergeStrategy(this.converter).merge(nbt, table, path);
        }
        throw this.converter.conversionException(path, data, "table");
    }
}

